import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class Rest {

    private static final String BASE_URL = "Enter Your Endpoint";
    private static final String ACCESS_KEY = "Enter Your API Key";
    private static final String DEFAULT_XML_PARAM = "&xml=true";
    private static final String DEFAULT_FORMAT_PARAM = "&format=CSV";
    private static final String LOG_FILE_NAME = "api_response_log.txt";

    public static void main(String[] args) throws Exception {
        // List of function names to be executed
        List<String> functionNames = Arrays.asList(
             "GetLastQuote",
             "GetLastQuoteShort",
             "GetLastQuoteShortWithClose",
             "GetLastQuoteArray",
             "GetLastQuoteArrayShort",
             "GetLastQuoteArrayShortWithClose",
             "GetSnapshot",
             "GetHistory",
             "GetExchanges",
             "GetInstrumentsOnSearch",
             "GetInstruments",
             "GetInstrumentTypes",
             "GetProducts",
             "GetExpiryDates",
             "GetOptionTypes",
             "GetStrikePrices",
             "GetServerInfo",
             "GetLimitation",
             "GetMarketMessages",
             "GetExchangeMessages",
             "GetLastQuoteOptionChain",
             "GetExchangeSnapshot",
             "GetSnapshotGreeks",
             "GetTopGainersLosers",
             "GetHistoryGreeks",
             "GetVolumeShockers",
            "default"
            // Add more function names here
        );

        // Iterate through the list and execute the request for each function
        // NOTE: 
        // if both XML & CVS are True  - return CSV format.
        // if both XML & CSV are False - return ByDefault JSON format.
        // if XML=True & CSV =False - return XML format.
        // Kindly Please make sure whatever you're giving.
        for (String functionName : functionNames) {
            switch (functionName) {
                case "GetLastQuote":
                    sendRequest("GetLastQuote",
                            getLastQuoteData("NFO", "NIFTY-I", false), true/*make true for XML View */, true/*make true for CSV View */);
                    break;
                case "GetLastQuoteShort":
                    sendRequest("GetLastQuoteShort",
                            getLastQuoteShortData("NFO", "NIFTY-I", false), true, true);
                    break;
                case "GetLastQuoteShortWithClose":
                    sendRequest("GetLastQuoteShortWithClose",
                            getLastQuoteShortWithCloseData("NFO", "NIFTY-I", false), true, true);
                    break;
                case "GetLastQuoteArray":
                    sendRequest("GetLastQuoteArray",
                            getLastQuoteArrayData("NFO", "NIFTY-I", false), true, true);
                    break;
                case "GetLastQuoteArrayShort":
                    sendRequest("GetLastQuoteArrayShort",
                            getLastQuoteArrayShortData("NFO", "NIFTY-I", false), true, true);
                    break;
                case "GetLastQuoteArrayShortWithClose":
                    sendRequest("GetLastQuoteArrayShortWithClose",
                            getLastQuoteArrayShortWithCloseData("NFO", "NIFTY-I", false), true, true);
                    break;
                case "GetSnapshot":
                    sendRequest("GetSnapshot",
                            getSnapshotData("NFO", "NIFTY-I+BANKNIFTY-I+FINNIFTY-I+MIDCPNIFTY-I", "Minute", 1, true), true, true);
                    break;
                case "GetHistory":
                  sendRequest("GetHistory",
                  		GetHistoryData("NFO", "NIFTY-I","Minute",1,10,0,0,false), true, false);
                  break; 
                case "GetExchanges":
                    sendRequest("GetExchanges",
                            getExchangesData(), true, false);
                    break;
                case "GetInstrumentsOnSearch":
                    sendRequest("GetInstrumentsOnSearch",
                            getInstrumentsOnSearchData("NFO", "NIFTY", "OPTIDX", "CE", "25NOV2025", 25000, true, true), true, false);
                    break;
                case "GetInstruments":
                    sendRequest("GetInstruments",
                            getInstrumentsData("NFO", "NIFTY", "OPTIDX", "CE", "25NOV2025", 25000, true, true), true, false);
                    break;
                case "GetInstrumentTypes":
                    sendRequest("GetInstrumentTypes",
                    		GetInstrumentTypesData("NFO"), true, false);
                    break;
                case "GetProducts":
                    sendRequest("GetProducts",
                    		GetProductsData("NFO"), true, false);
                    break;
                case "GetExpiryDates":
                    sendRequest("GetExpiryDates",
                    		GetExpiryDatesData("NFO","NIFTY",""), true, false);
                    break;
                case "GetOptionTypes":
                    sendRequest("GetOptionTypes",
                    		GetOptionTypesData("NFO"), true, false);
                    break;
                case "GetStrikePrices":
                    sendRequest("GetStrikePrices",
                    		GetStrikePricesData("NFO"), true, false);
                    break;
                case "GetServerInfo":
                    sendRequest("GetServerInfo",
                    		GetServerInfoData(), true, false);
                    break;
                case "GetLimitation":
                    sendRequest("GetLimitation",
                    		GetLimitationData(), true, false);
                    break;
                case "GetMarketMessages":
                    sendRequest("GetStrikePrices",
                    		GetMarketMessagesData("NFO"), true, false);
                    break;
                case "GetExchangeMessages":
                    sendRequest("GetExchangeMessages",
                    		GetExchangeMessagesData("NFO"), true, false);
                    break;
                case "GetLastQuoteOptionChain":
                    sendRequest("GetLastQuoteOptionChain",
                    		GetLastQuoteOptionChainData("NFO", "NIFTY", "CE", "25NOV2025", 25000), true, false);
                    break;
                case "GetExchangeSnapshot":
                    sendRequest("GetExchangeSnapshot",
                    		GetExchangeSnapshotData("NFO", "Minute",1,"FUTIDX",0,0,true,"user1"), true, false);
                    break; 
                case "GetSnapshotGreeks":
                    sendRequest("GetSnapshotGreeks",
                    		GetSnapshotGreeksData("NFO", "NIFTY25NOV2525500CE+BANKNIFTY25NOV2558000CE", "Minute", 1, true), true, true);
                    break;
                case "GetLastQuoteOptionGreeks":
                    sendRequest("GetLastQuoteOptionGreeks",
                    		GetLastQuoteOptionGreeksData("NFO", 52534), true, false);
                    break; 
                case "GetLastQuoteArrayOptionGreeks":
                    sendRequest("GetLastQuoteArrayOptionGreeks",
                    		GetLastQuoteArrayOptionGreeksData("NFO",39489+39487), true, false);
                    break; 
                case "GetLastQuoteOptionGreeksChain":
                    sendRequest("GetLastQuoteOptionGreeksChain",
                    		GetLastQuoteOptionGreeksChainData("NFO", "NIFTY", "CE", "25NOV2025", 25000), true, false);
                    break;
                case "GetTopGainersLosers":
                    sendRequest("GetTopGainersLosers",
                            GetTopGainersLosersData("NFO", 5), true, false);
                    break;
                case "GetHistoryGreeks":
                    sendRequest("GetHistoryGreeks",
                            GetHistoryGreeksData("NFO", "NIFTY25NOV2525500CE", "true" , "Minute" , 1 , 10 , 0 , 0), true, false);
                    break;
                case "GetVolumeShockers":
                    sendRequest("GetVolumeShockers",
                    		GetVolumeShockersData("NSE", 5), true, false);
                    break;
                // Add more cases for additional functions
                default:
                    System.out.println("Function not supported: " + functionName);
                    break;
            }
        }
    }

    private static String getLastQuoteData(String exchange, String instrumentIdentifiers, boolean isShortIdentifier) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifier=%s",
                ACCESS_KEY, exchange, instrumentIdentifiers));
        query.append("&isShortIdentifier=").append(isShortIdentifier);

        return query.toString();
    }

    private static String getLastQuoteShortData(String exchange, String instrumentIdentifier, boolean isShortIdentifier) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifier=%s",
                ACCESS_KEY, exchange, instrumentIdentifier));
        query.append("&isShortIdentifier=").append(isShortIdentifier);

        return query.toString();
    }

    private static String getLastQuoteShortWithCloseData(String exchange, String instrumentIdentifier, boolean isShortIdentifier) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifier=%s",
                ACCESS_KEY, exchange, instrumentIdentifier));
        query.append("&isShortIdentifier=").append(isShortIdentifier);

        return query.toString();
    }

    private static String getLastQuoteArrayData(String exchange, String instrumentIdentifiers, boolean isShortIdentifier) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifiers=%s",
                ACCESS_KEY, exchange, instrumentIdentifiers));
        query.append("&isShortIdentifiers=").append(isShortIdentifier);

        return query.toString();
    }

    private static String getLastQuoteArrayShortData(String exchange, String instrumentIdentifier, boolean isShortIdentifier) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifiers=%s",
                ACCESS_KEY, exchange, instrumentIdentifier));
        query.append("&isShortIdentifiers=").append(isShortIdentifier);

        return query.toString();
    }

    private static String getLastQuoteArrayShortWithCloseData(String exchange, String instrumentIdentifier, boolean isShortIdentifier) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifiers=%s",
                ACCESS_KEY, exchange, instrumentIdentifier));
        query.append("&isShortIdentifiers=").append(isShortIdentifier);

        return query.toString();
    }

    private static String getSnapshotData(String exchange, String instrumentIdentifier, String periodicity, int period, boolean isShortIdentifier) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifiers=%s&periodicity=%s&period=%d",
                ACCESS_KEY, exchange, instrumentIdentifier, periodicity, period));
        query.append("&isShortIdentifiers=").append(isShortIdentifier);

        return query.toString();
    }

  
	private static String GetHistoryData(String exchange, String instrumentIdentifier, String periodicity, int period, int max, int from, int to, boolean isShortIdentifier) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifier=%s&periodicity=%s&period=%d",
                ACCESS_KEY, exchange, instrumentIdentifier, periodicity, period));
        query.append("&max=").append(max);
        query.append("&from=").append(from);
        query.append("&to=").append(to);
        query.append("&isShortIdentifier=").append(isShortIdentifier);

        return query.toString();
    }

    private static String getExchangesData() {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s", ACCESS_KEY));

        return query.toString();
    }

    private static String getInstrumentsOnSearchData(String exchange, String search, String instrumentType, String optionType, String expiry, int strikePrice, boolean onlyActive, boolean detailedInfo) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&search=%s",
                ACCESS_KEY, exchange, search));
        if (instrumentType != null && !instrumentType.isEmpty()) {
            query.append("&instrumentType=").append(instrumentType);
        }
        if (optionType != null && !optionType.isEmpty()) {
            query.append("&optionType=").append(optionType);
        }
        if (expiry != null && !expiry.isEmpty()) {
            query.append("&expiry=").append(expiry);
        }
        if (strikePrice != 0) { // assuming strikePrice is a numeric type and can be zero or positive
            query.append("&strikePrice=").append(strikePrice);
        }
        query.append("&OnlyActive=").append(onlyActive);
        query.append("&detailedInfo=").append(detailedInfo);

        return query.toString();
    }
    private static String getInstrumentsData(String exchange, String product, String instrumentType, String optionType, String expiry, int strikePrice, boolean onlyActive, boolean detailedInfo) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&product=%s",
                ACCESS_KEY, exchange, product));
        query.append("&instrumentType=").append(instrumentType);
        query.append("&optionType=").append(optionType);
        query.append("&expiry=").append(expiry);
        query.append("&strikePrice=").append(strikePrice);
        query.append("&OnlyActive=").append(onlyActive);
        query.append("&detailedInfo=").append(detailedInfo);

        return query.toString();
        
    }
    private static String GetInstrumentTypesData(String exchange) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s", ACCESS_KEY,exchange));

        return query.toString();
    }
    private static String GetProductsData(String exchange) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s", ACCESS_KEY));
        query.append("&exchange=").append(exchange);
        return query.toString();
    }
    private static String GetExpiryDatesData(String exchange,String product,String instrumentType) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s", ACCESS_KEY,exchange));
        query.append("&product=").append(product);
        query.append("&instrumentType=").append(instrumentType);
        return query.toString();
    }
    private static String GetOptionTypesData(String exchange) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s", ACCESS_KEY,exchange));

        return query.toString();
    }
    private static String GetStrikePricesData(String exchange) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s", ACCESS_KEY,exchange));

        return query.toString();
    }
    private static String GetServerInfoData() {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s", ACCESS_KEY));

        return query.toString();
    }
    private static String GetLimitationData() {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s", ACCESS_KEY));

        return query.toString();
    }
    private static String GetMarketMessagesData(String exchange) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s", ACCESS_KEY,exchange));

        return query.toString();
    }
    private static String GetExchangeMessagesData(String exchange) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s", ACCESS_KEY,exchange));

        return query.toString();
    }
    private static String GetLastQuoteOptionChainData(String exchange, String product, String optionType, String expiry, int strikePrice) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&product=%s",
                ACCESS_KEY, exchange, product));
       
        query.append("&optionType=").append(optionType);
        query.append("&expiry=").append(expiry);
        query.append("&strikePrice=").append(strikePrice);
        

        return query.toString();
        
    }
    private static String GetExchangeSnapshotData(String exchange,  String periodicity, int period,String instrumentType,int from, int to, boolean nonTraded,String usertag) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&periodicity=%s&period=%d",
                ACCESS_KEY, exchange,periodicity, period));
        query.append("&instrumentType=").append(instrumentType);
        query.append("&from=").append(from);
        query.append("&to=").append(to);
        query.append("&nonTraded=").append(nonTraded);
        query.append("&usertag=").append(usertag);
        return query.toString();
    }
    private static String GetSnapshotGreeksData(String exchange, String instrumentIdentifier, String periodicity, int period, boolean isShortIdentifier) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifiers=%s&periodicity=%s&period=%d",
                ACCESS_KEY, exchange, instrumentIdentifier, periodicity, period));
        query.append("&isShortIdentifiers=").append(isShortIdentifier);

        return query.toString();
    }
    private static String GetLastQuoteOptionGreeksData(String exchange, int token) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&token=%d",
                ACCESS_KEY, exchange, token));
        
        return query.toString();
        
    }
    private static String GetLastQuoteArrayOptionGreeksData(String exchange, int tokens) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&tokens=%d",
                ACCESS_KEY, exchange, tokens));
        
        return query.toString();
        
    }
    
    private static String GetLastQuoteOptionGreeksChainData(String exchange, String product, String optionType, String expiry, int strikePrice) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&product=%s",
                ACCESS_KEY, exchange, product));
       
        query.append("&optionType=").append(optionType);
        query.append("&expiry=").append(expiry);
        query.append("&strikePrice=").append(strikePrice);
        

        return query.toString();
        
    }
    private static String GetTopGainersLosersData(String exchange, int count) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&count=%d",
                ACCESS_KEY, exchange, count));

        return query.toString();
        
    }
    private static String GetHistoryGreeksData(String exchange, String instrumentIdentifier, String isShortIdentifier, String periodicity, int period, int max, int from, int to) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&instrumentIdentifier=%s&isShortIdentifier=%s&periodicity=%s&period=%d",
                ACCESS_KEY, exchange, instrumentIdentifier , isShortIdentifier, periodicity , period)); 
        query.append("&max=").append(max);
        query.append("&from=").append(from);
        query.append("&to=").append(to);
        query.append("&periodicity=").append(periodicity);
        query.append("&period=").append(period);
        

        return query.toString();
    }
    private static String GetVolumeShockersData(String exchange, int count) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("accessKey=%s&exchange=%s&count=%d",
                ACCESS_KEY, exchange, count));

        return query.toString();
        
    }
    
//    ===========================================================================================================================================================//
    private static void sendRequest(String endpoint, String queryParams, boolean xml, boolean format) {
        StringBuilder urlBuilder = new StringBuilder(BASE_URL);
        urlBuilder.append(endpoint).append("?").append(queryParams);

        // Conditionally append XML and Format parameters
        if (xml) {
            urlBuilder.append(DEFAULT_XML_PARAM);
        }
        if (format) {
            urlBuilder.append(DEFAULT_FORMAT_PARAM);
        }

        String url = urlBuilder.toString();
        System.out.println("Sending request to URL: " + url);

        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            HttpGet request = new HttpGet(url);
            try (CloseableHttpResponse response = httpClient.execute(request)) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String result = EntityUtils.toString(entity);
                    System.out.println("Response: " + result);
                    logResponse(result,url.toString());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private static void logResponse(String response, String url) {
        File logFile = new File(LOG_FILE_NAME);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true))) {
            writer.write("Response logged at: " + java.time.LocalDateTime.now());
            writer.newLine();
            writer.write("-------------------------------------------------Response Start----------------------------------------------------");
            writer.newLine();
            writer.write("URL: " + url);
            writer.newLine();
            writer.write("Response: " + response);
            writer.newLine();
            writer.write("-------------------------------------------------Response end----------------------------------------------------");
            writer.newLine();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
