var DataObjects = [];

function LoadAsync(url, urlParameters, dataKey) {
    ShowInProgress(true);
    $.getJSON(url, urlParameters, function (data) {
        DataObjects[dataKey] = data;
        CallUpdateDataObjects();
        ShowInProgress(false);
    }).error(function (jqXHR, textStatus, errorThrown) {
        //console.log("error " + textStatus);
        if (jqXHR.responseText != null && jqXHR.responseText != '')
            ShowServerMassage(jqXHR.responseText);
        else {
            DataObjects[dataKey] = [];
            CallUpdateDataObjects();
            ShowInProgress(false);
        }
    });
}

function ShowServerMassage(val) {
    $('#lblValue').text(val);
}

function ShowInProgress(value) {
    if (value)
        ShowServerMassage('In progress...');
    else
        ShowServerMassage('Done');
}

function CallUpdateDataObjects() {
    $.each(DataObjects, function (key, val) {
        if (val != null) {
            switch (key) {
                case GET_EXCHANGES_KEY:
                    ProcessGetExchanges(val);
                    break;
                case GET_INSTRUMENTSONSEARCH_KEY:
                    ProcessGetInstrumentsOnSearch(val);
                    break;
                case GET_INSTRUMENTS_TOKEN_KEY:
                    ProcessGetInstruments(val);
                    break;
                default:
                    break;
            }
        }
    });
    DataObjects = [];
}