﻿using System;
using System.Net;
using System.Drawing;
using System.Collections.Generic;
using System.Net.WebSockets;
using System.Text;
using System.Threading;
using System.Windows.Forms;
//using System.Windows.Forms.VisualStyles;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using WebSocket = WebSocketSharp.WebSocket;
using System.Linq;
using System.Threading.Tasks;

namespace CH1
{
    public partial class WebsocketApi : Form
    {
        private WebSocket websocket;
        private readonly bool isAuthenticate = false;
        private FlowLayoutPanel myFlowLayoutPanel;
        private List<string> sentMessages = new List<string>();

        #region input string 
        private string GetExchangeValue()
        {
            return txtExchange.Text;
        }
        private string GetInstIdentifierValue()
        {
            return txtInstIdentifier.Text;
        }

        private string GetUnsubscribeValue()
        {
            return txtun.Text;
        }
        private string GetPeriodicityValue()
        {
            return txtPeriodicity.Text;
        }


        private int GetPeriodValue()
        {
            int period;
            if (int.TryParse(txtPeriod.Text, out period))
            {
                return period;
            }

            return 0;
        }
        private string GetIsShortIdentifierValue()
        {

            return txtisShortIdentifier.Text;
        }

        private string GetInstrumentIdentifiersValue()
        {
            List<Instrument> instrumentList = CreateInstrumentList(txtvalues.Text);


            return JsonConvert.SerializeObject(instrumentList);
        }

        private long GetFromValue()
        {
            DateTime selectedDate;
            if (DateTime.TryParse(dateTimePicker1.Value.ToString(), out selectedDate))
            {
                DateTimeOffset dateTimeOffset = new DateTimeOffset(selectedDate);
                return dateTimeOffset.ToUnixTimeSeconds();
            }
            return 0;
        }

        private long GetToValue()
        {
            DateTime selectedDate;
            if (DateTime.TryParse(dateTimePicker2.Value.ToString(), out selectedDate))
            {
                DateTimeOffset dateTimeOffset = new DateTimeOffset(selectedDate);
                return dateTimeOffset.ToUnixTimeSeconds();
            }
            return 0;
        }
        private long GetDateValue()
        {
            DateTime selectedDate;
            if (DateTime.TryParse(dateTimePicker3.Value.ToString(), out selectedDate))
            {
                DateTimeOffset dateTimeOffset = new DateTimeOffset(selectedDate);
                return dateTimeOffset.ToUnixTimeSeconds();
            }
            return 0;
        }


        private int GetMaxValue()
        {
            int max;
            if (int.TryParse(txtMax.Text, out max))
            {
                return max;
            }
            return 0;
        }

        private string GetSearchValue()
        {
            return txtSearch.Text;
        }

        private string GetProductValue()
        {
            return txtProduct.Text;
        }

        private string GetInstrumentTypeValue()
        {
            return txtInstrumentType.Text;
        }
        private string GetOptionTypesValue()

        {
            return txtOptionType.Text;
        }
        private string GetExpiryValue()

        {
            return txtExpiry.Text;
        }
        private string GetStrikePricesValue()

        {
            return txtStrikePrice.Text;
        }
        private string GetActiveValue()

        {
            return txtonlyactive.Text;
        }

        private string GetTokenValue()
        {
            List<Instrument> instrumentList = CreateInstrumentList(txtToken.Text);


            return JsonConvert.SerializeObject(instrumentList);
        }


        #endregion



        public WebsocketApi()
        {
            InitializeComponent();
            InitializeDropdown();

            HideAllTextBoxes();
            //flowLayoutPanel4.Visible = false;//
            //this.Resize += Form1_Resize;
            this.Resize += new EventHandler(MyForm_Resize);
            paneltext.Anchor = AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right;
            OS.Enabled = false;
            VM.Enabled = false;

        }
        private void MyForm_Resize(object sender, EventArgs e)
        {
            int bottomSpace = 50;
            int rightSpace = 25;

            paneltext.Size = new Size(this.ClientSize.Width - paneltext.Left - rightSpace, this.ClientSize.Height - paneltext.Top - bottomSpace);
        }
        private class Instrument
        {
            public string Value { get; set; }
        }
        private List<Instrument> CreateInstrumentList(string instrumentIdentifiersInput)
        {

            string[] identifiers = instrumentIdentifiersInput.Split(',');


            List<Instrument> instrumentList = new List<Instrument>();
            foreach (var identifier in identifiers)
            {
                instrumentList.Add(new Instrument { Value = identifier });
            }

            return instrumentList;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (websocket != null)
            {
                websocket.Close();
                websocket = null;
            }
        }
        #region visibility of the textbox and label accoridng to options
        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {

            HideAllTextBoxes();
            comboBox1.Visible = true;
            label2.Visible = true;
            button1.Visible = true;


            string selectedMethod = comboBox1.SelectedItem.ToString();
            lblrequest.Visible = true;
            SentBox.Visible = true;
            SentBox.Text = "";


            switch (selectedMethod)
            {
                case "SubscribeRealtime":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblInstIdentifier.Visible = true;
                    txtInstIdentifier.Visible = true;
                    lblUnsubscribe.Visible = true;
                    txtun.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;

                    Clear();
                    txtdescripition.Text = "Subscribes to realtime data (server will push new data whenever available)";
                    break;
                case "SubscribeSnapshot":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblPeriodicity.Visible = true;
                    txtPeriodicity.Visible = true;
                    lblPeriod.Visible = true;
                    txtPeriod.Visible = true;
                    lblInstIdentifier.Visible = true;
                    txtInstIdentifier.Visible = true;
                    lblUnsubscribe.Visible = true;
                    txtun.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Subscribes to minute snapshot data (server will push new data whenever available) ";
                    break;
                case "GetSnapshot":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblPeriodicity.Visible = true;
                    txtPeriodicity.Visible = true;
                    lblPeriod.Visible = true;
                    txtPeriod.Visible = true;
                    lblvalues.Visible = true;
                    txtvalues.Visible = true;
                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns latest Snapshot Data of multiple Symbols – max 25 in single call ";
                    break;
                case "GetLastQuote":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblInstIdentifier.Visible = true;
                    txtInstIdentifier.Visible = true;
                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns LastTradePrice of Single Symbol (detailed) ";
                    lblrequest.Visible = true;
                    SentBox.Visible = true;
                    break;
                case "GetLastQuoteShort":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblInstIdentifier.Visible = true;
                    txtInstIdentifier.Visible = true;
                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns LastTradePrice of Single Symbol (short)";
                    break;
                case "GetLastQuoteShortWithClose":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblInstIdentifier.Visible = true;
                    txtInstIdentifier.Visible = true;
                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns LastTradePrice of Single Symbol (short) with Close of Previous Day";
                    break;
                case "GetHistory":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblInstIdentifier.Visible = true;
                    txtInstIdentifier.Visible = true;
                    lblPeriodicity.Visible = true;
                    txtPeriodicity.Visible = true;
                    lblPeriod.Visible = true;
                    txtPeriod.Visible = true;
                    lblAdjustSplits.Visible = true;
                    txtAdjustSplits.Visible = true;
                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    lblFrom.Visible = true;
                    dateTimePicker1.Visible = true;
                    lblTo.Visible = true;
                    dateTimePicker2.Visible = true;
                    lblMax.Visible = true;
                    txtMax.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns historical data (Tick / Minute / EOD)";
                    break;
                case "GetExchanges":

                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns array of available exchanges configured for API Key";
                    break;
                case "GetInstrumentsOnSearch":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblSearch.Visible = true;
                    txtSearch.Visible = true;

                    lblInstrumentType.Visible = true;
                    txtInstrumentType.Visible = true;
                    lblProduct.Visible = true;
                    txtProduct.Visible = true;
                    lblOptionType.Visible = true;
                    txtOptionType.Visible = true;
                    lblExpiry.Visible = true;
                    txtExpiry.Visible = true;
                    lblStrikePrice.Visible = true;
                    txtStrikePrice.Visible = true;
                    Serieslbl.Visible = true;
                    txtseries.Visible = true;
                    lblOnlyActive.Visible = true;
                    txtonlyactive.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns array of max. 20 instruments by selected exchange and 'search string'";
                    break;
                case "GetInstruments":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblInstrumentType.Visible = true;
                    txtInstrumentType.Visible = true;
                    lblProduct.Visible = true;
                    txtProduct.Visible = true;
                    lblOptionType.Visible = true;
                    txtOptionType.Visible = true;
                    lblExpiry.Visible = true;
                    txtExpiry.Visible = true;
                    lblStrikePrice.Visible = true;
                    txtStrikePrice.Visible = true;
                    Serieslbl.Visible = true;
                    txtseries.Visible = true;
                    lbletf.Visible = true;
                    txtETF.Visible = true;
                    lblshowDummyISIN.Visible = true;
                    txtshowDummyISIN.Visible = true;
                    lblshowInterOperable.Visible = true;
                    txtshowInterOperable.Visible = true;
                    lblOnlyActive.Visible = true;
                    txtonlyactive.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns array of instruments by selected exchange";
                    break;
                case "GetInstrumentTypes":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns list of Instrument Types (e.g. FUTIDX, FUTSTK, etc.)";
                    break;
                case "GetExchangeMessages":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns array of last messages (Exchange Messages) related to selected exchange";
                    break;
                case "GetMarketMessages":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns array of last messages (Market Messages) related to selected exchange";
                    break;
                case "GetProducts":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;

                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns list of Products (e.g. NIFTY, BANKNIFTY, GAIL, etc.)";
                    break;
                case "GetExpiryDates":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblProduct.Visible = true;
                    txtProduct.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns array of Expiry Dates (e.g. 25JUN2020, 30JUL2020, etc.)";
                    break;
                case "GetOptionTypes":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;

                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns list of Option Types (e.g. CE, PE, etc.)";
                    break;

                case "GetLastQuoteOptionGreeksChain":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblProduct.Visible = true;
                    txtProduct.Visible = true;
                    lblExpiry.Visible = true;
                    txtExpiry.Visible = true;
                    lblOptionType.Visible = true;
                    txtOptionType.Visible = true;
                    lblStrikePrice.Visible = true;
                    txtStrikePrice.Visible = true;

                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns Last Traded Option Greek values of entire OptionChain of requested underlying";
                    break;
                case "GetLastQuoteArrayOptionGreeks":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblToken.Visible = true;
                    txtToken.Visible = true;

                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns Last Traded Option Greek values of multiple Symbols – max 25 in single call (detailed)";
                    break;
                case "GetLastQuoteOptionGreeks":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblToken.Visible = true;
                    txtToken.Visible = true;


                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns Last Traded Option Greek values of Single Symbol (detailed)";
                    break;
                case "SubscribeRealtimeGreeks":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblToken.Visible = true;
                    txtToken.Visible = true;
                    lblUnsubscribe.Visible = true;
                    txtun.Visible = true;


                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns Last Traded Option Greek values of Single Symbol (detailed)";
                    break;
                case "GetExchangeSnapshot":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;

                    lblPeriodicity.Visible = true;
                    txtPeriodicity.Visible = true;

                    lblPeriod.Visible = true;
                    txtPeriod.Visible = true;

                    lblInstrumentType.Visible = true;
                    txtInstrumentType.Visible = true;
                    txtInstrumentType.Text = "FUTSTK";

                    lblFrom.Visible = true;
                    dateTimePicker1.Visible = true;

                    lblTo.Visible = true;
                    dateTimePicker2.Visible = true;

                    lblnonTraded.Visible = true;
                    txtnonTraded.Visible = true;

                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns entire Exchange Snapshot in realtime";
                    break;
                case "GetLastQuoteOptionChain":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblProduct.Visible = true;
                    txtProduct.Visible = true;
                    lblExpiry.Visible = true;
                    txtExpiry.Visible = true;
                    lblOptionType.Visible = true;
                    txtOptionType.Visible = true;
                    lblStrikePrice.Visible = true;
                    txtStrikePrice.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns OptionChain data in realtime";
                    break;

                case "GetLimitation":
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns user account information (functions allowed, Exchanges allowed, symbol limit, etc.)";
                    break;
                case "GetServerInfo":
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns the server endpoint where user is connected";
                    break;
                case "GetStrikePrices":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns list of Strike Prices (e.g. 10000, 11000, 75.5, etc.)";
                    break;
                case "GetLastQuoteArrayShortWithClose":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblvalues.Visible = true;
                    txtvalues.Visible = true;
                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns LastTradePrice of multiple Symbols – max 25 in single call (short) with Previous Close";
                    break;
                case "GetLastQuoteArray":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblvalues.Visible = true;
                    txtvalues.Visible = true;
                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns LastTradePrice of multiple Symbols – max 25 in single call (detailed)";
                    break;
                case "GetLastQuoteArrayShort":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblvalues.Visible = true;
                    txtvalues.Visible = true;
                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns LastTradePrice of multiple Symbols – max 25 in single call (short) ";
                    break;
                case "GetExchangeSnapshotAfterMarket":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblPeriodicity.Visible = true;
                    txtPeriodicity.Visible = true;
                    lblPeriod.Visible = true;
                    txtPeriod.Visible = true;
                    lblInstrumentType.Visible = true;
                    txtInstrumentType.Visible = true;
                    lblDate.Visible = true;
                    dateTimePicker3.Visible = true;
                    lblTo.Visible = true;
                    dateTimePicker2.Visible = true;
                    lblnonTraded.Visible = true;
                    txtnonTraded.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns LastTradePrice of multiple Symbols – max 25 in single call (short) ";
                    break;
                case "SubscribeOptionChain":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblProduct.Visible = true;
                    txtProduct.Visible = true;
                    lblExpiry.Visible = true;
                    txtExpiry.Visible = true;
                    lblOptionType.Visible = true;
                    txtOptionType.Visible = true;
                    lblStrikePrice.Visible = true;
                    txtStrikePrice.Visible = true;
                    lblDEPTH.Visible = true;
                    txtDepth.Visible = true;
                    lblUnsubscribe.Visible = true;
                    txtun.Visible = true;
                    flowLayoutPanel1.Visible = true;
                    Clear();

                    break;
                case "SubscribeOptionChainGreeks":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblProduct.Visible = true;
                    txtProduct.Visible = true;
                    lblExpiry.Visible = true;
                    txtExpiry.Visible = true;
                    lblOptionType.Visible = true;
                    txtOptionType.Visible = true;
                    lblStrikePrice.Visible = true;
                    txtStrikePrice.Visible = true;
                    lblDEPTH.Visible = true;
                    txtDepth.Visible = true;
                    lblUnsubscribe.Visible = true;
                    txtun.Visible = true;
                    flowLayoutPanel1.Visible = true;
                    Clear();

                    break;

                case "SubscribeGainersLosers":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblcount.Visible = true;
                    txtcount.Visible = true;

                    lblUnsubscribe.Visible = true;
                    txtun.Visible = true;
                    flowLayoutPanel1.Visible = true;
                    Clear();

                    break;
                case "GetGainersLosers":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblcount.Visible = true;
                    txtcount.Visible = true;

                    flowLayoutPanel1.Visible = true;
                    Clear();

                    break;
                case "GetHistoryGreeks":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblInstIdentifier.Visible = true;
                    txtInstIdentifier.Visible = true;
                    lblPeriodicity.Visible = true;
                    txtPeriodicity.Visible = true;
                    lblPeriod.Visible = true;
                    txtPeriod.Visible = true;
                    

                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    lblFrom.Visible = true;
                    dateTimePicker1.Visible = true;
                    lblTo.Visible = true;
                    dateTimePicker2.Visible = true;
                    lblMax.Visible = true;
                    txtMax.Visible = true;

                    Clear();

                    break;
                case "SubscribeSnapshotGreeks":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblPeriodicity.Visible = true;
                    txtPeriodicity.Visible = true;
                    lblPeriod.Visible = true;
                    txtPeriod.Visible = true;
                    lblInstIdentifier.Visible = true;
                    txtInstIdentifier.Visible = true;
                    lblUnsubscribe.Visible = true;
                    txtun.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Subscribes to minute snapshotGreeks data (server will push new data whenever available) ";
                    break;
                case "GetSnapshotGreeks":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblPeriodicity.Visible = true;
                    txtPeriodicity.Visible = true;
                    lblPeriod.Visible = true;
                    txtPeriod.Visible = true;
                    lblvalues.Visible = true;
                    txtvalues.Visible = true;
                    lblisShortIdentifier.Visible = true;
                    txtisShortIdentifier.Visible = true;
                    flowLayoutPanel2.Visible = true;
                    lblDescription.Visible = true;
                    txtdescripition.Visible = true;
                    Clear();
                    txtdescripition.Text = "Returns latest SnapshotGreeks Data of multiple Symbols – max 25 in single call ";
                    break;
                case "GetVolumeShockers":
                    lblExchange.Visible = true;
                    txtExchange.Visible = true;
                    lblcount.Visible = true;
                    txtcount.Visible = true;
                    Serieslbl.Visible = true;
                    txtseries.Visible = true;

                    flowLayoutPanel1.Visible = true;
                    Clear();

                    break;

                default:

                    break;
            }
        }
        #endregion
        #region dropdown options
        private void InitializeDropdown()
        {
            comboBox1.Items.Add("--Select--");
            comboBox1.Items.Add("SubscribeRealtime");
            comboBox1.Items.Add("SubscribeSnapshot");
            comboBox1.Items.Add("GetLastQuote");
            comboBox1.Items.Add("GetLastQuoteShort");
            comboBox1.Items.Add("GetLastQuoteShortWithClose");
            comboBox1.Items.Add("GetLastQuoteArray");
            comboBox1.Items.Add("GetLastQuoteArrayShort");
            comboBox1.Items.Add("GetLastQuoteArrayShortWithClose");
            comboBox1.Items.Add("GetSnapshot");
            comboBox1.Items.Add("GetHistory");
            //comboBox1.Items.Add("GetExchanges");
            comboBox1.Items.Add("GetInstrumentsOnSearch");
            comboBox1.Items.Add("GetInstruments");
            comboBox1.Items.Add("GetInstrumentTypes");
            comboBox1.Items.Add("GetProducts");
            comboBox1.Items.Add("GetExpiryDates");
            comboBox1.Items.Add("GetOptionTypes");
            comboBox1.Items.Add("GetStrikePrices");
            //comboBox1.Items.Add("GetServerInfo");
            comboBox1.Items.Add("GetLimitation");
            comboBox1.Items.Add("GetMarketMessages");
            comboBox1.Items.Add("GetExchangeMessages");
            comboBox1.Items.Add("GetLastQuoteOptionChain");
            comboBox1.Items.Add("GetExchangeSnapshot");
            comboBox1.Items.Add("GetLastQuoteOptionGreeks");
            comboBox1.Items.Add("GetLastQuoteArrayOptionGreeks");
            comboBox1.Items.Add("GetLastQuoteOptionGreeksChain");
            comboBox1.Items.Add("GetExchangeSnapshotAfterMarket");
            comboBox1.Items.Add("SubscribeRealtimeGreeks");
            comboBox1.Items.Add("SubscribeSnapshotGreeks");
            comboBox1.Items.Add("GetSnapshotGreeks");
            comboBox1.Items.Add("SubscribeOptionChain");
            comboBox1.Items.Add("SubscribeOptionChainGreeks");
            comboBox1.Items.Add("SubscribeGainersLosers");
            comboBox1.Items.Add("GetGainersLosers");
            comboBox1.Items.Add("GetHistoryGreeks");
            comboBox1.Items.Add("GetVolumeShockers");
            comboBox1.SelectedIndex = 0;
            comboBox1.SelectedIndexChanged += comboBox1_SelectedIndexChanged;
        }
        #endregion
        private void Btnconnect_Click(object sender, EventArgs e)
        {



            if (btnconnect.Text == "Disconnect")
            {
                websocket.Close();
                websocket = null;
                btnconnect.Text = "Connect";
                txtserverid.Text = "";
                txtexchangeenabled.Text = "";

                HideAllTextBoxes();
                this.btnconnect.BackColor = System.Drawing.Color.Green;
                OS.Checked = true;
                VM.Checked = true;
                OS.Enabled = false;
                VM.Enabled = false;

            }
            else if (btnconnect.Text == "Connect")
            {
                string URI = txturi.Text;
                string APIKEY = txtapikey.Text;

                if (!string.IsNullOrEmpty(URI) && !string.IsNullOrEmpty(APIKEY))
                {
                    InitializeWebSocket(URI, APIKEY);
                    btnconnect.Text = "Disconnect";
                    comboBox1.Visible = true;
                    comboBox1.SelectedItem = "--Select--";
                    label2.Visible = true;
                    button1.Visible = true;
                    OS.Checked = true;
                    VM.Checked = true;
                    this.btnconnect.BackColor = System.Drawing.Color.Red;

                    GetServerInfo();

                    OS.Enabled = false;
                    VM.Enabled = false;

                }
                else
                {

                    MessageBox.Show("Please enter valid URI and APIKEY before connecting.");
                }
            }
        }
        #region Clear
        private void Clear()
        {
            txtExchange.Text = "NFO";
            txtInstIdentifier.Text = "NIFTY-I";
            txtun.Text = "false";
            txtPeriodicity.Text = "Minute";
            txtPeriod.Text = "1";
            txtisShortIdentifier.Text = "false";
            dateTimePicker1.Value = DateTime.Now;
            dateTimePicker2.Value = DateTime.Now;
            txtMax.Text = "10";
            txtSearch.Text = "NIFTY";
            txtProduct.Text = "NIFTY";
            txtInstrumentType.Text = "";
            txtToken.Text = "";
            dateTimePicker3.Value = DateTime.Now;
            txtOptionType.Text = "CE";
            txtExpiry.Text = "25APR2024";
            txtStrikePrice.Text = "22000";
            txtonlyactive.Text = "True";
            txtdescripition.Text = "";
            txtvalues.Text = "NIFTY-I,BANKNIFTY-I";
            paneltext.Text = "";
            SentBox.Text = "";
            txtDepth.Text = "20";
            txtcount.Text = "20";
            txtAdjustSplits.Text = "false";
            txtETF.Text = "false";
            txtshowDummyISIN.Text = "false";
            txtshowInterOperable.Text = "false";
            txtseries.Text = "EQ";





        }
        #endregion

        #region textboxhidden
        private void HideAllTextBoxes()
        {
            comboBox1.Visible = false;
            label2.Visible = false;
            button1.Visible = false;
            txtExchange.Visible = false;
            txtInstIdentifier.Visible = false;
            txtun.Visible = false;
            txtPeriodicity.Visible = false;
            txtPeriod.Visible = false;
            txtisShortIdentifier.Visible = false;
            dateTimePicker1.Visible = false;
            dateTimePicker2.Visible = false;
            txtMax.Visible = false;
            txtSearch.Visible = false;
            txtProduct.Visible = false;
            txtInstrumentType.Visible = false;
            txtToken.Visible = false;
            dateTimePicker3.Visible = false;
            txtOptionType.Visible = false;
            txtExpiry.Visible = false;
            txtStrikePrice.Visible = false;
            txtonlyactive.Visible = false;
            txtdescripition.Visible = false;
            txtvalues.Visible = false;
            txtnonTraded.Visible = false;
            SentBox.Visible = false;
            txtDepth.Visible = false;
            txtcount.Visible = false;
            txtAdjustSplits.Visible = false;
            txtshowDummyISIN.Visible = false;
            txtshowInterOperable.Visible = false;
            txtseries.Visible = false;  
            txtETF.Visible = false;


            lblExchange.Visible = false;
            lblInstIdentifier.Visible = false;
            lblUnsubscribe.Visible = false;
            lblDate.Visible = false;
            lblPeriodicity.Visible = false;
            lblPeriod.Visible = false;
            lblisShortIdentifier.Visible = false;
            lblFrom.Visible = false;
            lblTo.Visible = false;
            lblMax.Visible = false;
            lblSearch.Visible = false;
            lblProduct.Visible = false;
            lblInstrumentType.Visible = false;
            lblToken.Visible = false;
            lblOptionType.Visible = false;
            lblExpiry.Visible = false;
            lblStrikePrice.Visible = false;
            lblOnlyActive.Visible = false;
            lblDescription.Visible = false;
            lblvalues.Visible = false;
            lblnonTraded.Visible = false;
            label3.Visible = true;
            lblrequest.Visible = false;
            lblDEPTH.Visible = false;
            lblcount.Visible = false;
            lblAdjustSplits.Visible = false;
            Serieslbl.Visible = false;
            lblshowDummyISIN.Visible = false;
            lblshowInterOperable.Visible = false;
            lbletf.Visible = false;

        }

        #endregion
        #region InitializeWebSocket
        private void InitializeWebSocket(string uri, string apiKey)
        {

            websocket = new WebSocket(uri);

            websocket.OnOpen += (sender, e) =>
            {

                Authenticate(websocket, apiKey);

            };

            websocket.OnMessage += (sender, e) =>
            {
                Console.WriteLine("Response : " + e.Data);
                if (IsEchoMessage(e.Data))
                {

                    HandleEchoMessage(e.Data);
                }
                else
                {

                    DisplayResult(e.Data);

                }


            };


            websocket.OnError += (sender, e) =>
            {

                MessageBox.Show("Error");
            };

            websocket.OnClose += (sender, e) =>
            {
                DisplayDisconnectedMessage();
            };

            websocket.Connect();
        }

        private void DisplayDisconnectedMessage()
        {
            Clear();
            MessageBox.Show("WebSocket connection disconnected. Please connect again to go ahead.");


        }

        #endregion
        private bool IsEchoMessage(string message)
        {

            return message.Contains("MessageType\":\"Echo\"");
        }

        private void HandleEchoMessage(string echoMessage)
        {

            Console.WriteLine("Echo Message Received: " + echoMessage);

        }
        private static void Authenticate(WebSocket ws, string apiKey)
        {

            ws.Send($"{{\"MessageType\":\"Authenticate\",\"Password\":\"{apiKey}\"}}");
        }

        #region Working Results
        private void DisplayResult(string result)
        {


            Label label = new Label
            {
                Text = result + Environment.NewLine,
                AutoSize = false,
                AutoEllipsis = true,
                Size = new Size(200, 0),
                MaximumSize = new Size(200, 0),
                TextAlign = ContentAlignment.TopLeft
            };


            JObject jsonObject = JObject.Parse(result);
            var resultcondtion = (jsonObject.TryGetValue("Result", out JToken resultToken));

            if (jsonObject.TryGetValue("ServerID", out JToken serverIdToken))
            {
                string serverIdValue = serverIdToken.ToString();
                txtserverid.BeginInvoke((MethodInvoker)(() => txtserverid.Text = serverIdValue));
                //GetExchangeEnabled();
                Task.Delay(2000).ContinueWith(_ =>
                {
                    this.BeginInvoke((MethodInvoker)(() => GetExchangeEnabled()));
                });
            }
            else if (jsonObject.TryGetValue("MessageType", out JToken messageTypeToken) && (messageTypeToken.ToString() == "ExchangesResult"))
            {
                string messageType = messageTypeToken.ToString();
                if (messageType == "ExchangesResult" && resultToken is JArray resultArray)
                {
                    var exchanges = resultArray
                        .Select(token => token["Value"].ToString())
                        .ToList();

                    string filteredResult = string.Join(", ", exchanges);
                    txtexchangeenabled.BeginInvoke((MethodInvoker)(() => txtexchangeenabled.Text = filteredResult));
                }

            }
            else if (jsonObject.TryGetValue("GeneralParams", out JToken resultidToken) && jsonObject.TryGetValue("MessageType", out JToken messageTypeidToken))
            {

                string responseText = "";
                foreach (var prop in jsonObject)
                {
                    responseText += $"{prop.Key}: {prop.Value}{Environment.NewLine}";
                }
                label.Text = responseText;
                paneltext.BeginInvoke((MethodInvoker)(() => paneltext.Text = responseText));
            }
            else if (jsonObject.TryGetValue("AllowVMRunning", out JToken allowVMRunningToken) && allowVMRunningToken.Type == JTokenType.Boolean)
            {
                bool allowVMRunning = allowVMRunningToken.Value<bool>();


                if (!allowVMRunning)
                {

                    VM.Invoke((MethodInvoker)(() =>
                    {
                        VM.Checked = false;
                    }));
                }
            }
            else if (jsonObject.TryGetValue("AllowServerOSRunning", out JToken allowServerOSRunningToken) && allowServerOSRunningToken.Type == JTokenType.Boolean)
            {
                bool allowServerOSRunning = allowServerOSRunningToken.Value<bool>();


                if (!allowServerOSRunning)
                {

                    OS.Invoke((MethodInvoker)(() =>
                    {
                        OS.Checked = false;
                    }));
                }
            }
            else if (jsonObject.TryGetValue("MessageType", out JToken messageTypeTokenids) && messageTypeTokenids.ToString() == "RealtimeSnapshotCollection")
            {
                AppendTextToPanel("RealtimeSnapshotCollection", result);
            }
            else if (jsonObject.TryGetValue("MessageType", out JToken messageTypeTokenOption) && messageTypeTokenOption.ToString() == "RealtimeOptionChainResult")
            {
                AppendTextToPanel("RealtimeOptionChainResult", result);
            }
            else
            {
                var timestamp = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");

                paneltext.BeginInvoke((MethodInvoker)(() =>
                {

                    paneltext.Visible = true;

                    int start = paneltext.TextLength;
                    paneltext.AppendText($"Time: {timestamp} - ");
                    paneltext.Select(start, timestamp.Length + 6);
                    paneltext.SelectionColor = Color.Blue;
                    paneltext.AppendText($"Response: {result}{Environment.NewLine}");
                    paneltext.Select(paneltext.TextLength, 0);
                    paneltext.SelectionColor = paneltext.ForeColor;

                }));

                // if required you need to check for the response timing you can eanble from tyhe line to be uncommented and cehck .
                //var timestamp = DateTime.Now;

                //paneltext.BeginInvoke((MethodInvoker)(() =>
                //{
                //    int start = paneltext.TextLength;
                //    paneltext.AppendText($"Time: {timestamp:yyyy-MM-dd HH:mm:ss.ffff} - ");
                //    paneltext.Select(start, timestamp.ToString("yyyy-MM-dd HH:mm:ss.ffff").Length + 6); // +6 for the " - " part
                //    paneltext.SelectionColor = Color.Blue;

                //    paneltext.AppendText($"Response: {result} ");
                //    paneltext.Select(paneltext.TextLength - result.Length - 10, result.Length + 10); // -10 for "Response: " part
                //    paneltext.SelectionColor = paneltext.ForeColor;

                //    int endStart = paneltext.TextLength;
                //    var endtimestamp = DateTime.Now;
                //    paneltext.AppendText($"End Time: {endtimestamp:yyyy-MM-dd HH:mm:ss.ffff} ");
                //    paneltext.Select(endStart, endtimestamp.ToString("yyyy-MM-dd HH:mm:ss.ffff").Length + 11); // +11 for "End Time: " part
                //    paneltext.SelectionColor = Color.Red;

                //    var difference = endtimestamp - timestamp;
                //    int diffStart = paneltext.TextLength;
                //    paneltext.AppendText($"Difference: {difference.TotalMilliseconds:0} ms{Environment.NewLine}{Environment.NewLine}");
                //    paneltext.Select(diffStart, difference.TotalMilliseconds.ToString().Length + 13); // +13 for "Difference: " and " ms"
                //    paneltext.SelectionColor = Color.DarkRed;

                //    var jsonResponse = JObject.Parse(result);
                //    var resultArray = jsonResponse["Result"] as JArray;
                //    int recordCount = resultArray?.Count ?? 0;

                //    paneltext.AppendText($"Total number of InstrumentIdentifiers: {recordCount}{Environment.NewLine}{Environment.NewLine}");
                //    paneltext.Select(paneltext.TextLength - $"Total number of InstrumentIdentifiers: {recordCount}{Environment.NewLine}".Length, $"Total number of InstrumentIdentifiers: {recordCount}".Length);
                //    paneltext.SelectionColor = Color.DarkRed;
                //}));
            }

        }
        void AppendTextToPanel(string messageType, string result)
        {
            var timestamp = DateTime.Now;

            paneltext.BeginInvoke((MethodInvoker)(() =>
            {
                paneltext.Visible = true;
                int start = paneltext.TextLength;
                paneltext.AppendText($"Time: {timestamp:yyyy-MM-dd HH:mm:ss.ffff} - ");
                paneltext.Select(start, timestamp.ToString("yyyy-MM-dd HH:mm:ss.ffff").Length + 6); // +6 for the " - " part
                paneltext.SelectionColor = Color.Blue;

                if (messageType == "RealtimeSnapshotCollection")
                {
                    var jsonResponse = JObject.Parse(result);
                    var exchange = jsonResponse["Exchange"]?.ToString();
                    var periodicity = jsonResponse["Periodicity"]?.ToString();
                    var period = jsonResponse["Period"]?.ToString();
                    var limitedResults = jsonResponse["Result"]?.Take(10);

                    var resultArray = jsonResponse["Result"] as JArray;
                    int recordCount = resultArray?.Count ?? 0;

                    string trimmedResult = JsonConvert.SerializeObject(new
                    {
                        Exchange = exchange,
                        Periodicity = periodicity,
                        Period = period,
                        Result = limitedResults
                    }, Formatting.None);

                    paneltext.AppendText($"Response: {trimmedResult} ");
                    paneltext.Select(paneltext.TextLength - trimmedResult.Length - 10, trimmedResult.Length + 10); // -10 for "Response: " part
                    paneltext.SelectionColor = paneltext.ForeColor;

                    int endStart = paneltext.TextLength;
                    var endtimestamp = DateTime.Now;
                    paneltext.AppendText($"End Time: {endtimestamp:yyyy-MM-dd HH:mm:ss.ffff} ");
                    paneltext.Select(endStart, endtimestamp.ToString("yyyy-MM-dd HH:mm:ss.ffff").Length + 11); // +11 for "End Time: " part
                    paneltext.SelectionColor = Color.Red;

                    var difference = endtimestamp - timestamp;
                    int diffStart = paneltext.TextLength;
                    paneltext.AppendText($"Difference: {difference.TotalMilliseconds:0} ms ");
                    paneltext.Select(diffStart, difference.TotalMilliseconds.ToString().Length + 13); // +13 for "Difference: " and " ms"
                    paneltext.SelectionColor = Color.DarkRed;

                    paneltext.AppendText($"Total Records: {recordCount}{Environment.NewLine}{Environment.NewLine}");
                }
                else if (messageType == "RealtimeOptionChainResult")
                {
                    paneltext.AppendText($"Response: {result} ");
                    paneltext.Select(paneltext.TextLength - result.Length - 10, result.Length + 10); // -10 for "Response: " part
                    paneltext.SelectionColor = paneltext.ForeColor;

                    int endStart = paneltext.TextLength;
                    var endtimestamp = DateTime.Now;
                    paneltext.AppendText($"End Time: {endtimestamp:yyyy-MM-dd HH:mm:ss.ffff} ");
                    paneltext.Select(endStart, endtimestamp.ToString("yyyy-MM-dd HH:mm:ss.ffff").Length + 11); // +11 for "End Time: " part
                    paneltext.SelectionColor = Color.Red;

                    var difference = endtimestamp - timestamp;
                    int diffStart = paneltext.TextLength;
                    paneltext.AppendText($"Difference: {difference.TotalMilliseconds:0} ms{Environment.NewLine}{Environment.NewLine}");
                    paneltext.Select(diffStart, difference.TotalMilliseconds.ToString().Length + 13); // +13 for "Difference: " and " ms"
                    paneltext.SelectionColor = Color.DarkRed;

                    // Append the count of InstrumentIdentifiers
                    var jsonResponse = JObject.Parse(result);
                    var resultArray = jsonResponse["Result"] as JArray;
                    int recordCount = resultArray?.Count ?? 0;

                    paneltext.AppendText($"Total number of InstrumentIdentifiers: {recordCount}{Environment.NewLine}{Environment.NewLine}");
                    paneltext.Select(paneltext.TextLength - $"Total number of InstrumentIdentifiers: {recordCount}{Environment.NewLine}".Length, $"Total number of InstrumentIdentifiers: {recordCount}".Length);
                    paneltext.SelectionColor = Color.DarkRed;
                }

            }));
        }
        #endregion Working Results

        private void GetServerInfo()
        {
            if (websocket != null && websocket.IsAlive)
            {
                string message = "{\"MessageType\":\"GetServerInfo\"}";
                websocket.Send(message);

            }

        }
        private void GetExchangeEnabled()
        {
            if (websocket != null && websocket.IsAlive)
            {
                string message = "{\"MessageType\":\"GetExchanges\"}";
                websocket.Send(message);
            }
        }
        private void Button1_Click(object sender, EventArgs e)
        {
            paneltext.Text = "";
            string selectedMethod = comboBox1.SelectedItem.ToString();
            InvokeMethod(websocket, selectedMethod);

        }

        #region dropdown value passing 
        private void InvokeMethod(WebSocket ws, string method)
        {

            switch (method)
            {
                case "--Select--": Select(ws); break;
                case "SubscribeRealtime": SubscribeRealtime(ws, GetExchangeValue(), GetInstIdentifierValue(), GetUnsubscribeValue()); break;
                case "SubscribeSnapshot": SubscribeSnapshot(ws, GetExchangeValue(), GetInstIdentifierValue(), GetPeriodicityValue(), GetPeriodValue(), GetUnsubscribeValue()); break;
                case "GetLastQuote": GetLastQuote(ws, GetExchangeValue(), GetInstIdentifierValue(), GetUnsubscribeValue()); break;
                case "GetLastQuoteShort": GetLastQuoteShort(ws, GetExchangeValue(), GetInstIdentifierValue(), GetIsShortIdentifierValue()); break;
                case "GetLastQuoteShortWithClose": GetLastQuoteShortWithClose(ws, GetExchangeValue(), GetInstIdentifierValue(), GetIsShortIdentifierValue()); break;
                case "GetLastQuoteArray": GetLastQuoteArray(ws, GetExchangeValue(), GetInstrumentIdentifiersValue(), GetIsShortIdentifierValue()); break;
                case "GetLastQuoteArrayShort": GetLastQuoteArrayShort(ws, GetExchangeValue(), GetIsShortIdentifierValue(), GetInstrumentIdentifiersValue()); break;
                case "GetLastQuoteArrayShortWithClose": GetLastQuoteArrayShortWithClose(ws, GetExchangeValue(), GetIsShortIdentifierValue(), GetInstrumentIdentifiersValue()); break;
                case "GetSnapshot": GetSnapshot(ws, GetExchangeValue(), GetInstrumentIdentifiersValue(), GetPeriodicityValue(), GetPeriodValue(), GetIsShortIdentifierValue()); break;
                case "GetHistory": GetHistory(ws, GetPeriodicityValue(), GetPeriodValue(), GetExchangeValue(), GetInstIdentifierValue(), GetIsShortIdentifierValue(), GetFromValue(), GetToValue(), GetMaxValue(),txtAdjustSplits.Text); break;
                //case "GetExchanges": GetExchanges(ws); break;
                case "GetInstrumentsOnSearch": GetInstrumentsOnSearch(ws, GetExchangeValue(), GetSearchValue(), GetProductValue(), GetInstrumentTypeValue(), GetOptionTypesValue(), GetExpiryValue(),txtseries.Text, GetStrikePricesValue(), GetActiveValue()); break;
                case "GetInstruments": GetInstruments(ws, GetExchangeValue(), GetProductValue(), GetInstrumentTypeValue(), GetOptionTypesValue(), GetExpiryValue(), GetStrikePricesValue(),txtseries.Text,txtshowDummyISIN.Text,txtshowInterOperable.Text,txtETF.Text, GetActiveValue()); break;
                case "GetInstrumentTypes": GetInstrumentTypes(ws, GetExchangeValue()); break;
                case "GetProducts": GetProducts(ws, GetExchangeValue()); break;
                case "GetExpiryDates": GetExpiryDates(ws, GetExchangeValue(), GetProductValue()); break;
                case "GetOptionTypes": GetOptionTypes(ws, GetExchangeValue()); break;
                case "GetStrikePrices": GetStrikePrices(ws, GetExchangeValue()); break;
                //case "GetServerInfo": GetServerInfo(ws); break;
                case "GetLimitation": GetLimitation(ws); break;
                case "GetMarketMessages": GetMarketMessages(ws, GetExchangeValue()); break;
                case "GetExchangeMessages": GetExchangeMessages(ws, GetExchangeValue()); break;
                case "GetLastQuoteOptionChain": GetLastQuoteOptionChain(ws, GetExchangeValue(), GetProductValue(), GetOptionTypesValue(), GetExpiryValue(), GetStrikePricesValue()); break;
                case "GetExchangeSnapshot": GetExchangeSnapshot(ws, GetExchangeValue(), GetPeriodicityValue(), GetPeriodValue(), GetInstrumentTypeValue(), GetFromValue(), GetToValue()); break;
                case "GetLastQuoteOptionGreeks": GetLastQuoteOptionGreeks(ws, GetExchangeValue(), GetTokenValue()); break;
                case "GetLastQuoteArrayOptionGreeks": GetLastQuoteArrayOptionGreeks(ws, GetExchangeValue(), GetTokenValue()); break;
                case "GetLastQuoteOptionGreeksChain": GetLastQuoteOptionGreeksChain(ws, GetExchangeValue(), GetProductValue(), GetExpiryValue(), GetOptionTypesValue(), GetStrikePricesValue()); break;
                case "SubscribeRealtimeGreeks": SubscribeRealtimeGreeks(ws, GetExchangeValue(), GetTokenValue()); break;
                case "GetExchangeSnapshotAfterMarket": GetExchangeSnapshotAfterMarket(ws, GetExchangeValue(), GetPeriodicityValue(), GetPeriodValue(), GetInstrumentTypeValue(), GetDateValue(), GetToValue()); break;
                case "SubscribeOptionChain": SubscribeOptionChain(ws, txtExchange.Text, txtProduct.Text, txtExpiry.Text, txtOptionType.Text, txtStrikePrice.Text, int.Parse(txtcount.Text), txtun.Text); break;
                case "SubscribeOptionChainGreeks": SubscribeOptionChainGreeks(ws, txtExchange.Text, txtProduct.Text, txtExpiry.Text, txtOptionType.Text, txtStrikePrice.Text, int.Parse(txtcount.Text), txtun.Text); break;
                case "SubscribeGainersLosers": SubscribeGainersLosers(ws, txtExchange.Text, int.Parse(txtcount.Text), txtun.Text); break;
                case "GetGainersLosers": GetGainersLosers(ws, txtExchange.Text, int.Parse(txtcount.Text)); break;
                case "GetHistoryGreeks": GetHistoryGreeks(ws, txtExchange.Text, txtInstIdentifier.Text,txtPeriodicity.Text,int.Parse(txtPeriod.Text), txtisShortIdentifier.Text, GetFromValue(), GetToValue(), int.Parse(txtMax.Text)); break;
                case "SubscribeSnapshotGreeks": SubscribeSnapshotGreeks(ws, GetExchangeValue(), GetInstIdentifierValue(), GetPeriodicityValue(), GetPeriodValue(), GetUnsubscribeValue()); break;
                case "GetSnapshotGreeks": GetSnapshotGreeks(ws, GetExchangeValue(), GetInstrumentIdentifiersValue(), GetPeriodicityValue(), GetPeriodValue(), GetIsShortIdentifierValue()); break;
                case "GetVolumeShockers": GetVolumeShockers(ws, txtExchange.Text, int.Parse(txtcount.Text) ,txtseries.Text); break;

                default:
                    Console.WriteLine("Invalid method selected");
                    break;
            }
        }
        #endregion

        #region methodof dropdown call
        private static void Select(WebSocket ws)
        {
        }
        private void SubscribeRealtime(WebSocket ws, string exchange, string instIdentifier, string unsubscribe)
        {
            string Exchange = exchange;
            string Unsubscribe = string.IsNullOrEmpty(unsubscribe) ? "false" : unsubscribe;

            // Split the instrument identifiers by comma
            string[] identifiers = instIdentifier.Split(',');
            List<string> sentMessages = new List<string>();
            foreach (string identifier in identifiers)
            {
                if (!string.IsNullOrEmpty(Exchange) && !string.IsNullOrEmpty(identifier) || !string.IsNullOrEmpty(Unsubscribe))
                {
                    string strMessage = $"{{\"MessageType\":\"SubscribeRealtime\",\"Exchange\":\"{ Exchange }\"," +
                                        $"\"Unsubscribe\":\"{ Unsubscribe }\"," +
                                        $"\"InstrumentIdentifier\":\"{ identifier.Trim() }\"}}";

                    ws.Send(strMessage);
                    sentMessages.Add(strMessage);
                    printsentmessage(strMessage);
                }

            }



        }

        private void SubscribeSnapshot(WebSocket ws, string exchange, string instIdentifier, string periodicity, int period, string unsubscribe)
        {
            string ExchangeName = exchange;
            string InstIdentifier = instIdentifier;
            string Periodicity = GetPeriodicityValue();
            int Period = GetPeriodValue();
            string Unsubscribe = GetUnsubscribeValue();
            string strMessage = $"{{\"MessageType\":\"SubscribeSnapshot\",\"Exchange\":\"{ ExchangeName }\",\"InstrumentIdentifier\":\"{ InstIdentifier }\",\"Period\":\"{ Period }\",\"Periodicity\":\"{ Periodicity }\",\"Unsubscribe\":\"{ Unsubscribe }\"}}";

            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetLastQuote(WebSocket ws, string exchange, string instIdentifier, string isshortIdentifier)
        {
            string ExchangeName = exchange;
            string InstIdentifier = instIdentifier;
            string isShortIdentifier = GetIsShortIdentifierValue();
            if (!string.IsNullOrEmpty(ExchangeName) && !string.IsNullOrEmpty(isShortIdentifier) && !string.IsNullOrEmpty(InstIdentifier))
            {
                string strMessage = $"{{\"MessageType\":\"GetLastQuote\",\"Exchange\":\"{ExchangeName}\"";

                if (!string.IsNullOrEmpty(InstIdentifier))
                    strMessage += $",\"InstrumentIdentifier\":\"{InstIdentifier}\"";


                if (!string.IsNullOrEmpty(isShortIdentifier))
                    strMessage += $",\"isShortIdentifier\":\"{isShortIdentifier}\"";

                strMessage += "}";

                ws.Send(strMessage);
                printsentmessage(strMessage);

            }


        }



        private void GetLastQuoteShort(WebSocket ws, string exchange, string instIdentifier, string isshortIdentifier)
        {
            string ExchangeName = exchange;
            string InstIdentifier = instIdentifier;
            string isShortIdentifier = GetIsShortIdentifierValue();
            string strMessage = $"{{\"MessageType\":\"GetLastQuoteShort\",\"Exchange\":\"{ ExchangeName }\",\"isShortIdentifier\":\"{ isShortIdentifier }\",\"InstrumentIdentifier\":\"{ InstIdentifier }\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetLastQuoteShortWithClose(WebSocket ws, string exchange, string instIdentifier, string isshortIdentifier)
        {
            string ExchangeName = exchange;
            string InstIdentifier = instIdentifier;
            string isShortIdentifier = GetIsShortIdentifierValue();
            string strMessage = $"{{\"MessageType\":\"GetLastQuoteShortWithClose\",\"Exchange\":\"{ ExchangeName }\",\"isShortIdentifier\":\"{ isShortIdentifier }\",\"InstrumentIdentifier\":\"{ InstIdentifier }\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetLastQuoteArray(WebSocket ws, string exchange, string isshortidentifier, string instrumentIdentifiersInput)
        {

            string ExchangeName = exchange;
            string isShortIdentifiers = GetIsShortIdentifierValue();
            string instrumentIdentifiers = GetInstrumentIdentifiersValue();

            string strMessage = $"{{\"MessageType\":\"GetLastQuoteArray\",\"Exchange\":\"{ ExchangeName }\",\"isShortIdentifier\":\"{ isShortIdentifiers }\",\"InstrumentIdentifiers\":{ instrumentIdentifiers }}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetLastQuoteArrayShort(WebSocket ws, string exchange, string isshortidentifier, string instrumentIdentifiersInput)
        {
            string ExchangeName = exchange;
            string isShortIdentifiers = isshortidentifier;
            string InstrumentIdentifiers = instrumentIdentifiersInput;

            string strMessage = $"{{\"MessageType\":\"GetLastQuoteArrayShort\",\"Exchange\":\"{ ExchangeName }\",\"isShortIdentifier\":\"{ isShortIdentifiers }\",\"InstrumentIdentifiers\":{ InstrumentIdentifiers}}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }


        private void GetLastQuoteArrayShortWithClose(WebSocket ws, string exchange, string isshortidentifier, string instrumentIdentifiersInput)
        {
            string ExchangeName = exchange;
            string isShortIdentifiers = GetIsShortIdentifierValue();
            string instrumentIdentifiers = GetInstrumentIdentifiersValue();

            string strMessage = $"{{\"MessageType\":\"GetLastQuoteArrayShortWithClose\",\"Exchange\":\"{ ExchangeName }\",\"isShortIdentifier\":\"{ isShortIdentifiers }\",\"InstrumentIdentifiers\":{ instrumentIdentifiers }}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetSnapshot(WebSocket ws, string exchange, string instrumentIdentifiersInput, string periodicity, int period, string isshortidentifier)
        {
            string ExchangeName = exchange;
            string Periodicity = GetPeriodicityValue();
            int Period = GetPeriodValue();
            string InstrumentIdentifiers = GetInstrumentIdentifiersValue();
            string isShortIdentifiers = GetIsShortIdentifierValue();
            string strMessage = $"{{\"MessageType\":\"GetSnapshot\",\"Exchange\":\"{ ExchangeName }\",\"Periodicity\":\"{ Periodicity }\",\"Period\":\"{ Period }\",\"isShortIdentifiers\":\"{ isShortIdentifiers }\",\"InstrumentIdentifiers\":{ InstrumentIdentifiers}}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetHistory(WebSocket ws, string periodicity, int period, string exchange, string instidentifier, string isshortidentifier, long from, long to, int max,string adjustSplits)
        {
            string ExchangeName = exchange;
            string InstIdentifier = instidentifier;
            string Periodicity = periodicity;
            int Period = period;
            long From = from;
            long To = to;
            int Max = max;
            string UserTag = "User1";
            string isShortIdentifier = isshortidentifier;
            string AdjustSplits = adjustSplits;

            if (!string.IsNullOrEmpty(ExchangeName) && !string.IsNullOrEmpty(Periodicity) && ((period) > 0 || (From) != 0 || (To) != 0 || (Max) != 0))
            {
                string strMessage = $"{{\"MessageType\":\"GetHistory\",\"Exchange\":\"{ExchangeName}\",\"UserTag\":\"{UserTag}\"";

                if (!string.IsNullOrEmpty(Periodicity))
                    strMessage += $",\"Periodicity\":\"{Periodicity}\"";

                if (Period > 0)
                    strMessage += $",\"Period\":{Period}";

                if (!string.IsNullOrEmpty(instidentifier))
                    strMessage += $",\"InstrumentIdentifier\":\"{InstIdentifier}\"";

                if (From != To && From != DateTimeOffset.UtcNow.ToUnixTimeMilliseconds())
                    strMessage += $",\"From\":{From}";

                if (To != From && To != DateTimeOffset.UtcNow.ToUnixTimeMilliseconds())
                    strMessage += $",\"To\":{To}";
                if ((Max) != 0)
                    strMessage += $",\"Max\":{max}";
                if (!string.IsNullOrEmpty(isShortIdentifier))
                    strMessage += $",\"isShortIdentifier\":\"{isShortIdentifier}\"";
                if (!string.IsNullOrEmpty(AdjustSplits))
                    strMessage += $",\"AdjustSplits\":\"{adjustSplits}\"";

                strMessage += "}";

                ws.Send(strMessage);
                printsentmessage(strMessage);

            }
        }

        private void GetInstrumentsOnSearch(WebSocket ws, string exchange, string search, string product, string instrumenttype, string optiontype, string expiry, string strikeprice,string series, string onlyactive)
        {
            string ExchangeName = exchange;
            string Search = search;
            string Product = product;
            string InstrumentType = instrumenttype;
            string OptionType = optiontype;
            string Expiry = expiry;
            string StrikePrice = strikeprice;
            string Series = series;
            string OnlyActive = onlyactive;

            if (!string.IsNullOrEmpty(ExchangeName) && (!string.IsNullOrEmpty(Search) || !string.IsNullOrEmpty(Product) || !string.IsNullOrEmpty(InstrumentType)
                || !string.IsNullOrEmpty(OptionType) || !string.IsNullOrEmpty(Expiry) || !string.IsNullOrEmpty(StrikePrice) || !string.IsNullOrEmpty(OnlyActive) || !string.IsNullOrEmpty(Series)))
            {
                string strMessage = $"{{\"MessageType\":\"GetInstrumentsOnSearch\",\"Exchange\":\"{ExchangeName}\",";

                if (!string.IsNullOrEmpty(Search))
                    strMessage += $"\"Search\":\"{Search}\",";
                if (!string.IsNullOrEmpty(Product))
                    strMessage += $"\"Product\":\"{Product}\",";
                if (!string.IsNullOrEmpty(InstrumentType))
                    strMessage += $"\"InstrumentType\":\"{InstrumentType}\",";
                if (!string.IsNullOrEmpty(OptionType))
                    strMessage += $"\"OptionType\":\"{OptionType}\",";
                if (!string.IsNullOrEmpty(Expiry))
                    strMessage += $"\"Expiry\":\"{Expiry}\",";
                if (!string.IsNullOrEmpty(StrikePrice))
                    strMessage += $"\"StrikePrice\":\"{StrikePrice}\",";
                if (!string.IsNullOrEmpty(Series))
                    strMessage += $"\"Series\":\"{Series}\",";
                if (!string.IsNullOrEmpty(OnlyActive))
                    strMessage += $"\"OnlyActive\":\"{OnlyActive}\",";
                if (strMessage.EndsWith(","))
                    strMessage = strMessage.Remove(strMessage.Length - 1);
                strMessage += "}";


                ws.Send(strMessage);
                printsentmessage(strMessage);

            }
        }

        private void GetInstruments(WebSocket ws, string exchange, string product, string instrumenttype, string optiontype, string expiry, string strikeprice,string series, string etf,string interoper,string isn, string onlyactive)
        {
            string ExchangeName = exchange;
            string Product = GetProductValue();
            string InstrumentType = GetInstrumentTypeValue();
            string OptionType = GetOptionTypesValue();
            string Expiry = GetExpiryValue();
            string StrikePrice = GetStrikePricesValue();
            string Series = series;
            string ShowETF = etf;
            string ShowDummyISIN = isn;
            string ShowINteroperable = interoper;
            string OnlyActive = GetActiveValue();

            if (!string.IsNullOrEmpty(ExchangeName) && (!string.IsNullOrEmpty(Product) || !string.IsNullOrEmpty(InstrumentType)
                || !string.IsNullOrEmpty(OptionType) || !string.IsNullOrEmpty(Expiry) || !string.IsNullOrEmpty(StrikePrice) || !string.IsNullOrEmpty(Series) || !string.IsNullOrEmpty(ShowETF) 
                || !string.IsNullOrEmpty(ShowDummyISIN) || !string.IsNullOrEmpty(ShowINteroperable) || !string.IsNullOrEmpty(OnlyActive)))
            {
                string strMessage = $"{{\"MessageType\":\"GetInstruments\",\"Exchange\":\"{ExchangeName}\",";

                if (!string.IsNullOrEmpty(InstrumentType))
                    strMessage += $"\"InstrumentType\":\"{InstrumentType}\",";
                if (!string.IsNullOrEmpty(Product))
                    strMessage += $"\"Product\":\"{Product}\",";

                if (!string.IsNullOrEmpty(OptionType))
                    strMessage += $"\"OptionType\":\"{OptionType}\",";
                if (!string.IsNullOrEmpty(Expiry))
                    strMessage += $"\"Expiry\":\"{Expiry}\",";
                if (!string.IsNullOrEmpty(StrikePrice))
                    strMessage += $"\"StrikePrice\":\"{StrikePrice}\",";
                if (!string.IsNullOrEmpty(Series))
                    strMessage += $"\"Series\":\"{Series}\",";
                if (!string.IsNullOrEmpty(ShowETF))
                    strMessage += $"\"ShowETF\":\"{ShowETF}\",";
                if (!string.IsNullOrEmpty(ShowDummyISIN))
                    strMessage += $"\"showDummyISIN\":\"{ShowDummyISIN}\",";
                if (!string.IsNullOrEmpty(ShowINteroperable))
                    strMessage += $"\"showInterOperable\":\"{ShowINteroperable}\",";
                if (!string.IsNullOrEmpty(OnlyActive))
                    strMessage += $"\"OnlyActive\":\"{OnlyActive}\",";
                if (strMessage.EndsWith(","))
                    strMessage = strMessage.Remove(strMessage.Length - 1);
                strMessage += "}";


                ws.Send(strMessage);
                printsentmessage(strMessage);

            }
        }

        private void GetServerInfo(WebSocket ws)
        {
            string strMessage = $"{{\"MessageType\":\"GetServerInfo\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetExchanges(WebSocket ws)
        {
            string strMessage = $"{{\"MessageType\":\"GetExchanges\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetInstrumentTypes(WebSocket ws, string exchange)
        {
            string ExchangeName = exchange;
            string strMessage = $"{{\"MessageType\":\"GetInstrumentTypes\",\"Exchange\":\"{ ExchangeName }\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetProducts(WebSocket ws, string exchange)
        {
            string ExchangeName = exchange;
            string strMessage = $"{{\"MessageType\":\"GetProducts\",\"Exchange\":\"{ ExchangeName }\"}}";
            ws.Send(strMessage); printsentmessage(strMessage);
        }


        private void GetExpiryDates(WebSocket ws, string exchange, string product)
        {
            string ExchangeName = exchange;
            string Product = GetProductValue();
            string strMessage = $"{{\"MessageType\":\"GetExpiryDates\",\"Exchange\":\"{ ExchangeName }\",\"Product\":\"{ Product }\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetOptionTypes(WebSocket ws, string exchange)
        {
            string ExchangeName = exchange;
            string strMessage = $"{{\"MessageType\":\"GetOptionTypes\",\"Exchange\":\"{ ExchangeName }\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetStrikePrices(WebSocket ws, string exchange)
        {
            string ExchangeName = exchange;
            string strMessage = $"{{\"MessageType\":\"GetStrikePrices\",\"Exchange\":\"{ ExchangeName }\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetLimitation(WebSocket ws)
        {
            string strMessage = $"{{\"MessageType\":\"GetLimitation\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetMarketMessages(WebSocket ws, string exchange)
        {
            string ExchangeName = exchange;
            string strMessage = $"{{\"MessageType\":\"GetMarketMessages\",\"Exchange\":\"{ ExchangeName }\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetExchangeMessages(WebSocket ws, string exchange)
        {
            string ExchangeName = exchange;
            string strMessage = $"{{\"MessageType\":\"GetExchangeMessages\",\"Exchange\":\"{ ExchangeName }\"}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetLastQuoteOptionChain(WebSocket ws, string exchange, string product, string optiontype, string expiry, string strikeprice)
        {
            string Exchange = exchange;
            string Product = product;
            string OptionType = optiontype;
            string Expiry = expiry;
            string StrikePrice = strikeprice;

            if (!string.IsNullOrEmpty(Exchange) && (!string.IsNullOrEmpty(Product) || !string.IsNullOrEmpty(OptionType) || !string.IsNullOrEmpty(Expiry) || !string.IsNullOrEmpty(StrikePrice)))
            {
                string strMessage = $"{{\"MessageType\":\"GetLastQuoteOptionChain\",\"Exchange\":\"{Exchange}\",";

                if (!string.IsNullOrEmpty(Product))
                    strMessage += $"\"Product\":\"{Product}\",";
                if (!string.IsNullOrEmpty(OptionType))
                    strMessage += $"\"OptionType\":\"{OptionType}\",";
                if (!string.IsNullOrEmpty(Expiry))
                    strMessage += $"\"Expiry\":\"{Expiry}\",";
                if (!string.IsNullOrEmpty(StrikePrice))
                    strMessage += $"\"StrikePrice\":\"{StrikePrice}\",";
                if (strMessage.EndsWith(","))
                    strMessage = strMessage.Remove(strMessage.Length - 1);

                strMessage += "}";

                ws.Send(strMessage);
                printsentmessage(strMessage);

            }
        }

        private void GetExchangeSnapshot(WebSocket ws, string exchange, string periodicity, int period, string instrumenttype, long from, long to)
        {
            string Exchange = exchange;
            string Periodicity = periodicity;
            int Period = period;
            string InstrumentType = instrumenttype;
            long From = from;
            long To = to;
            string nonTraded = txtnonTraded.Text;

            if (!string.IsNullOrEmpty(Exchange) && !string.IsNullOrEmpty(Periodicity) && ((period) > 0 || (From) != 0 || (To) != 0))
            {
                string strMessage = $"{{\"MessageType\":\"GetExchangeSnapshot\",\"Exchange\":\"{Exchange}\"";

                if (!string.IsNullOrEmpty(Periodicity))
                    strMessage += $",\"Periodicity\":\"{Periodicity}\"";

                if (Period > 0)
                    strMessage += $",\"Period\":{Period}";

                if (!string.IsNullOrEmpty(InstrumentType))
                    strMessage += $",\"InstrumentType\":\"{InstrumentType}\"";

                if (From != To && From != DateTimeOffset.UtcNow.ToUnixTimeMilliseconds())
                    strMessage += $",\"From\":{From}";

                if (To != From && To != DateTimeOffset.UtcNow.ToUnixTimeMilliseconds())
                    strMessage += $",\"To\":{To}";
                if (!string.IsNullOrEmpty(nonTraded))
                    strMessage += $",\"nonTraded\":\"{nonTraded}\"";


                strMessage += "}";

                ws.Send(strMessage);
                printsentmessage(strMessage);

            }
        }

        private void GetExchangeSnapshotAfterMarket(WebSocket ws, string exchange, string periodicity, int period, string instrumnettype, long XDate, long to)
        {
            string Exchange = txtExchange.Text;
            string Periodicity = txtPeriodicity.Text;
            string nonTraded = txtnonTraded.Text;
            string InstrumentType = txtInstrumentType.Text;
            int Period = period;
            long xDate = XDate;
            long To = to;
            if (!string.IsNullOrEmpty(Exchange) && !string.IsNullOrEmpty(Periodicity) && ((period) > 0 || (XDate) != 0 || (To) != 0))
            {
                string strMessage = $"{{\"MessageType\":\"GetExchangeSnapshotAfterMarket\",\"Exchange\":\"{Exchange}\"";

                if (!string.IsNullOrEmpty(Periodicity))
                    strMessage += $",\"Periodicity\":\"{Periodicity}\"";

                if (Period > 0)
                    strMessage += $",\"Period\":{Period}";

                if (!string.IsNullOrEmpty(InstrumentType))
                    strMessage += $",\"InstrumentType\":\"{InstrumentType}\"";

                if (XDate != To && XDate != DateTimeOffset.UtcNow.ToUnixTimeMilliseconds())
                    strMessage += $",\"XDate\":{XDate}";

                if (To != XDate && To != DateTimeOffset.UtcNow.ToUnixTimeMilliseconds())
                    strMessage += $",\"To\":{To}";
                if (!string.IsNullOrEmpty(nonTraded))
                    strMessage += $",\"nonTraded\":\"{nonTraded}\"";
                strMessage += "}";

                ws.Send(strMessage);
                printsentmessage(strMessage);
            };

        }

        private void GetLastQuoteOptionGreeks(WebSocket ws, string exchange, string token)
        {
            string Exchange = exchange;
            string Token = txtToken.Text;
            string strMessage = $"{{\"MessageType\":\"GetLastQuoteOptionGreeks\",\"Exchange\":\"{ Exchange }\",\"Token\":\"{ Token }\"}}";

            ws.Send(strMessage);
            printsentmessage(strMessage);
        }
        private void SubscribeRealtimeGreeks(WebSocket ws, string exchange, string token)
        {
            string Exchange = exchange;
            string Token = txtToken.Text;
            string Unsubscribe = txtun.Text;
            string strMessage = $"{{\"MessageType\":\"SubscribeRealtimeGreeks\",\"Exchange\":\"{ Exchange }\",\"Token\":\"{ Token }\",\"Unsubscribe\":\"{ Unsubscribe }\"}}";

            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetLastQuoteArrayOptionGreeks(WebSocket ws, string exchange, string token)
        {
            string Exchange = exchange;
            string Tokens = token;
            string strMessage = $"{{\"MessageType\":\"GetLastQuoteArrayOptionGreeks\",\"Exchange\":\"{ Exchange }\",\"Tokens\":\"{ Tokens }\"}}";
            Console.WriteLine(strMessage);
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetLastQuoteOptionGreeksChain(WebSocket ws, string exchange, string product, string expiry, string optiontype, string strikeprice)
        {
            string Exchange = exchange;
            string Product = product;
            string OptionType = optiontype;
            string Expiry = expiry;
            string StrikePrice = strikeprice;

            if (!string.IsNullOrEmpty(Exchange) && (!string.IsNullOrEmpty(product) || !string.IsNullOrEmpty(optiontype) || !string.IsNullOrEmpty(expiry) || !string.IsNullOrEmpty(strikeprice)))
            {
                string strMessage = $"{{\"MessageType\":\"GetLastQuoteOptionGreeksChain\",\"Exchange\":\"{Exchange}\",";
                if (!string.IsNullOrEmpty(Product))
                    strMessage += $"\"Product\":\"{Product}\",";
                if (!string.IsNullOrEmpty(OptionType))
                    strMessage += $"\"OptionType\":\"{OptionType}\",";
                if (!string.IsNullOrEmpty(Expiry))
                    strMessage += $"\"Expiry\":\"{Expiry}\",";
                if (!string.IsNullOrEmpty(StrikePrice))
                    strMessage += $"\"StrikePrice\":\"{StrikePrice}\",";
                if (strMessage.EndsWith(","))
                    strMessage = strMessage.Remove(strMessage.Length - 1);
                strMessage += "}";

                ws.Send(strMessage);
                printsentmessage(strMessage);

            }
        }
        private void SubscribeOptionChain(WebSocket ws, string exchange, string product, string expiry, string optionType, string strikePrice, int depth, string unsubscribe)
        {
            string ExchangeName = exchange;
            string Product = product;
            string Expiry = expiry;
            string OptionType = optionType;
            string StrikePrice = strikePrice;
            int Depth = depth;
            string Unsubscribe = unsubscribe;
            {
                if (string.IsNullOrEmpty(ExchangeName) && string.IsNullOrEmpty(Product) && string.IsNullOrEmpty(Expiry) && string.IsNullOrEmpty(StrikePrice) && Depth != 0)
                {
                    MessageBox.Show("Required fields are missing or invalid");
                    return;
                }

                var message = new JObject
                {
                    ["MessageType"] = "SubscribeOptionChain",["Exchange"] = exchange,["Product"] = product,
                    ["Expiry"] = expiry,
                    ["StrikePrice"] = strikePrice,
                    ["Depth"] = depth
                };

                if (!string.IsNullOrEmpty(OptionType))
                {
                    message["OptionType"] = optionType;
                }

                if (!string.IsNullOrEmpty(Unsubscribe))
                {
                    message["Unsubscribe"] = unsubscribe;
                }

                ws.Send(message.ToString());
                printsentmessage(message.ToString());
            }
        }
        private void SubscribeOptionChainGreeks(WebSocket ws, string exchange, string product, string expiry, string optionType, string strikePrice, int depth, string unsubscribe)
        {
            string ExchangeName = exchange;
            string Product = product;
            string Expiry = expiry;
            string OptionType = optionType;
            string StrikePrice = strikePrice;
            int Depth = depth;
            string Unsubscribe = unsubscribe;
            {
                if (string.IsNullOrEmpty(ExchangeName) && string.IsNullOrEmpty(Product) && string.IsNullOrEmpty(Expiry) && string.IsNullOrEmpty(StrikePrice) && Depth != 0)
                {
                    MessageBox.Show("Required fields are missing or invalid");
                    return;
                }

                var message = new JObject
                {
                    ["MessageType"] = "SubscribeOptionChainGreeks",
                    ["Exchange"] = exchange,
                    ["Product"] = product,
                    ["Expiry"] = expiry,
                    ["StrikePrice"] = strikePrice,
                    ["Depth"] = depth
                };

                if (!string.IsNullOrEmpty(OptionType))
                {
                    message["OptionType"] = optionType;
                }

                if (!string.IsNullOrEmpty(Unsubscribe))
                {
                    message["Unsubscribe"] = unsubscribe;
                }

                ws.Send(message.ToString());
                printsentmessage(message.ToString());
            }
        }
        private void SubscribeGainersLosers(WebSocket ws, string exchange, int count, string unsubscribe)
        {
            string ExchangeName = exchange;

            int Count = count;
            string Unsubscribe = unsubscribe;
            {
                if (string.IsNullOrEmpty(ExchangeName) && Count != 0)
                {
                    MessageBox.Show("Required fields are missing or invalid");
                    return;
                }

                var message = new JObject
                {
                    ["MessageType"] = "SubscribeTopGainersLosers",["Exchange"] = exchange,["Count"] = count
                };

                if (!string.IsNullOrEmpty(Unsubscribe))
                {
                    message["Unsubscribe"] = unsubscribe;
                }

                ws.Send(message.ToString());
                printsentmessage(message.ToString());
            }
        }
        private void GetGainersLosers(WebSocket ws, string exchange, int count)
        {
            string ExchangeName = exchange;

            int Count = count;

            {
                if (string.IsNullOrEmpty(ExchangeName) && Count != 0)
                {
                    MessageBox.Show("Required fields are missing or invalid");
                    return;
                }

                var message = new JObject
                {
                    ["MessageType"] = "GetTopGainersLosers",
                    ["Exchange"] = exchange,
                    ["Count"] = count
                };
                ws.Send(message.ToString());
                printsentmessage(message.ToString());
            }
        }

        private void GetHistoryGreeks(WebSocket ws, string exchange, string instidentifier,string perodicity,int period, string isshortidentifier, long from, long to, int max)
        {
            string ExchangeName = exchange;
            string InstIdentifier = instidentifier;
            string Perodicity = perodicity;
            int Period = period;
            long From = from;
            long To = to;
            int Max = max;

            string isShortIdentifier = isshortidentifier;

            if (!string.IsNullOrEmpty(ExchangeName) && !string.IsNullOrEmpty(instidentifier) && !string.IsNullOrEmpty(perodicity) && (period) !=0 || ((From) != 0 || (To) != 0 || (Max) != 0))
            {
                string strMessage = $"{{\"MessageType\":\"GetHistoryGreeks\",\"Exchange\":\"{ExchangeName}\",\"InstrumentIdentifier\":\"{InstIdentifier}\",\"Perodicity\":\"{Perodicity}\",\"Period\":\"{Period}\"";


                if (From != To && From != DateTimeOffset.UtcNow.ToUnixTimeMilliseconds())
                    strMessage += $",\"From\":{From}";

                if (To != From && To != DateTimeOffset.UtcNow.ToUnixTimeMilliseconds())
                    strMessage += $",\"To\":{To}";
                if ((Max) != 0)
                    strMessage += $",\"Max\":{max}";
                if (!string.IsNullOrEmpty(isShortIdentifier))
                    strMessage += $",\"isShortIdentifier\":\"{isShortIdentifier}\"";

                strMessage += "}";

                ws.Send(strMessage);
                printsentmessage(strMessage);            //MessageBox.Show(strMessage);
            }
        }
        private void SubscribeSnapshotGreeks(WebSocket ws, string exchange, string instIdentifier, string periodicity, int period, string unsubscribe)
        {
            string ExchangeName = exchange;
            string InstIdentifier = instIdentifier;
            string Periodicity = GetPeriodicityValue();
            int Period = GetPeriodValue();
            string Unsubscribe = GetUnsubscribeValue();
            string strMessage = $"{{\"MessageType\":\"SubscribeSnapshotGreeks\",\"Exchange\":\"{ExchangeName}\",\"InstrumentIdentifier\":\"{InstIdentifier}\",\"Period\":\"{Period}\",\"Periodicity\":\"{Periodicity}\",\"Unsubscribe\":\"{Unsubscribe}\"}}";

            ws.Send(strMessage);
            printsentmessage(strMessage);
        }
        private void GetSnapshotGreeks(WebSocket ws, string exchange, string instrumentIdentifiersInput, string periodicity, int period, string isshortidentifier)
        {
            string ExchangeName = exchange;
            string Periodicity = GetPeriodicityValue();
            int Period = GetPeriodValue();
            string InstrumentIdentifiers = GetInstrumentIdentifiersValue();
            string isShortIdentifiers = GetIsShortIdentifierValue();
            string strMessage = $"{{\"MessageType\":\"GetSnapshotGreeks\",\"Exchange\":\"{ExchangeName}\",\"Periodicity\":\"{Periodicity}\",\"Period\":\"{Period}\",\"isShortIdentifiers\":\"{isShortIdentifiers}\",\"InstrumentIdentifiers\":{InstrumentIdentifiers}}}";
            ws.Send(strMessage);
            printsentmessage(strMessage);
        }

        private void GetVolumeShockers(WebSocket ws, string exchange, int count ,string series)
        {
            string ExchangeName = exchange;

            int Count = count;
            string Series = series;

            string strMessage = $"{{\"MessageType\":\"GetVolumeShockers\",\"Exchange\":\"{ExchangeName}\",\"Count\":\"{Count}\"";
            if (!string.IsNullOrEmpty(Series))
                strMessage += $",\"Series\":\"{Series}\"";

            strMessage += "}";
            ws.Send(strMessage);
            printsentmessage(strMessage);

           
        }
        #endregion

        private void Btnclear_Click(object sender, EventArgs e)
        {
            paneltext.Text = "";
        }

        private void printsentmessage(string message)
        {
            SentBox.Text = message;
        }


    }


}

