/*
 * Decompiled with CFR 0.152.
 */
package com.pfl.samples.jee7.websocket;

import java.io.IOException;
import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
public class WSClientEndpoint {
    Session userSession = null;
    boolean APIConnection = false;

    public WSClientEndpoint(URI endpointURI) {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.connectToServer(this, endpointURI);
        }
        catch (IOException | DeploymentException Ex) {
            throw new RuntimeException(Ex);
        }
    }

    @OnOpen
    public void onOpen(Session userSession) {
        this.userSession = userSession;
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        this.userSession = null;
        System.out.println(reason);
    }

    @OnMessage
    public void onMessage(String message) {
        if (message != null) {
            if (message.contains("\"Complete\":true") || message.contains("\"AllowVMRunning\":false") || message.contains("\"AllowServerOSRunning\":false")) {
                this.APIConnection = true;
                System.out.println("Authentication Complete!");
            } else {
                System.out.println(message);
            }
        }
    }

    public void sendMessage(String message) {
        System.out.println(message);
        this.userSession.getAsyncRemote().sendText(message);
    }

    public static interface MessageHandler {
        public void handleMessage(String var1);
    }
}

