/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.WriteFuture;

class ConnectionImpl
extends Connection {
    private final FilterChainContext ctx;
    private final HttpContent httpContent;
    private final org.glassfish.grizzly.Connection connection;

    public ConnectionImpl(FilterChainContext ctx, HttpContent httpContent) {
        this.ctx = ctx;
        this.connection = ctx.getConnection();
        this.httpContent = httpContent;
    }

    public ConnectionImpl(org.glassfish.grizzly.Connection connection) {
        this.connection = connection;
        this.ctx = null;
        this.httpContent = null;
    }

    public Future<DataFrame> write(final DataFrame frame, final Connection.CompletionHandler completionHandler) {
        if (!this.connection.isOpen()) {
            return null;
        }
        final WriteFuture future = new WriteFuture();
        this.connection.write((Object)frame, (CompletionHandler)new EmptyCompletionHandler(){

            public void completed(Object result) {
                if (completionHandler != null) {
                    completionHandler.completed((Object)frame);
                }
                future.setResult((Object)frame);
            }

            public void failed(Throwable throwable) {
                if (completionHandler != null) {
                    completionHandler.failed(throwable);
                }
                future.setFailure(throwable);
            }
        });
        return future;
    }

    public void write(WebSocketResponse response) {
        if (this.ctx == null) {
            throw new UnsupportedOperationException("not supported on client side");
        }
        HttpResponsePacket responsePacket = ((HttpRequestPacket)this.httpContent.getHttpHeader()).getResponse();
        responsePacket.setProtocol(Protocol.HTTP_1_1);
        responsePacket.setStatus(response.getStatus());
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            responsePacket.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        this.ctx.write((Object)HttpContent.builder((HttpHeader)responsePacket).build());
    }

    public void addCloseListener(final Connection.CloseListener closeListener) {
        final ConnectionImpl webSocketConnection = this;
        this.connection.addCloseListener(new CloseListener(){

            public void onClosed(Closeable closeable, ICloseType iCloseType) throws IOException {
                closeListener.onClose(webSocketConnection);
            }
        });
    }

    public void closeSilently() {
        this.connection.closeSilently();
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Connection && this.connection.equals(((Connection)obj).getUnderlyingConnection());
    }

    public Object getUnderlyingConnection() {
        return this.connection;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " " + this.connection.toString() + " " + this.connection.hashCode();
    }
}

