/*
 * This is sample application which is created to show, How Websocket API of
 * Global Datafeeds can be consumed using JAVA. In this sample .jar files used
 * are given in the below list
 *  1. javax.json-1.1.2.jar
 *  2. javax.json-api-1.1.2.jar
 *  3. javax.websocket-api-1.1.jar
 *  4. javax.websocket-api-1.1-sources.jar
 *  5. tyrus-standalone-client-1.9.jar
 */

package com.pfl.samples.jee7.websocket;

import java.net.URI;
import javax.json.Json;
import javax.json.JsonObjectBuilder;

/**
 * @author GFDL-Development
 */

public class WebSocketSample_JAVA {
    public static void main(String[] args) throws Exception {
        
    	//GFDL TODO - please enter below the endpoint received from GFDL team. If you dont have one, please contact us on sales@globaldatafeeds.in 
        String EndPoint = "please enter below the endpoint";
        
        //GFDL TODO - please enter below the API Key received from GFDL team. If you dont have one, please contact us on sales@globaldatafeeds.in 
        String AccessKey = "please enter below the API Key";

        
        /*GFDL TODO : All the functions supported by API are listed below. You can uncomment any function to see the flow of request and response*/
        
        String functionName = "SubscribeRealtime";
        //String functionName = "SubscribeSnapshot";

        //String functionName = "GetLastQuote";
        //String functionName = "GetLastQuoteShort";
        //String functionName = "GetLastQuoteShortWithClose";
        //String functionName = "GetLastQuoteArray";
        //String functionName = "GetLastQuoteArrayShort";
        //String functionName = "GetLastQuoteArrayShortWithClose";
        
//        String functionName = "GetSnapshot";
        //String functionName = "GetHistory";

        //String functionName = "GetExchanges";

        //String functionName = "GetInstrumentsOnSearch";
        //String functionName = "GetInstruments";

        //String functionName = "GetInstrumentTypes";
        //String functionName = "GetProducts";
        //String functionName = "GetExpiryDates";
        //String functionName = "GetOptionTypes";
        //String functionName = "GetStrikePrices";

        //String functionName = "GetServerInfo";
        //String functionName = "GetLimitation";

        //String functionName = "GetMarketMessages";
        //String functionName = "GetExchangeMessages";

//        String functionName = "GetLastQuoteOptionChain";
        //String functionName = "GetExchangeSnapshot";
//        String functionName = "GetLastQuoteOptionGreeks";
//        String functionName = "GetLastQuoteArrayOptionGreeks";
//        String functionName = "GetLastQuoteOptionGreeksChain";
//        String functionName = "SubscribeRealtimeGreeks";
//        String functionName = "SubscribeSnapshotGreeks";
//        String functionName = "GetSnapshotGreeks";
//        String functionName = "SubscribeOptionChain";
//        String functionName = "SubscribeOptionChainGreeks";
//        String functionName = "SubscribeTopGainersLosers";
//        String functionName = "GetTopGainersLosers";
//        String functionName = "GetHistoryGreeks";
//        String functionName = "GetVolumeShockers";
        final WSClientEndpoint clientEndPoint;
        clientEndPoint = new WSClientEndpoint(new URI(EndPoint));
        
        //Here user is Authenticated using "getAuthenticate" function
        clientEndPoint.sendMessage(getAuthenticate("Authenticate",AccessKey));
        Thread.sleep(500);
        
        
        if(clientEndPoint.APIConnection)
        {       	
            switch (functionName) {
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			/* 	GFDL : 	1. 	SubscribeRealtime : pushes realtime data every second for the subscribed instrument from server
			2. 	So you will need to send this request only once and subscribe for the data.	
			3.	Please note that if there is internet disconnection for any reason, you will need to 
			subscribe to all the instruments again - to receive the data.
			4.	To see this function in action, you should run it during market hours
			5.	If you want to subscribe to data of multiple symbols, you will need to send 1 request each - for each symbol
			6. 	Please see symbol naming conventions here : https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/
			*/
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	            case "SubscribeRealtime":
	            	//Below request will subscribe to realtime data of Current Month Futures of NIFTY	
	            	//This example shows how to request data using Continuous Format
	            	//Similarly, you can send NIFTY-II (Near month), NIFTY-III (Far month). 
	            	//Below Symbol is Continuous Format of NIFTY Futures. It will never expire. So no change in code will be necessary.
	            	//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
	            	//CDS Examples : USDINR-I, USDINR-II, USDINR-III
	            	//MCX Examples : NATURALGAS-I, NATURALGAS-II, NATURALGAS-III
	            	
	            	// Please see symbol naming conventions here : 
	            	// https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/

	            	clientEndPoint.sendMessage(SubscribeRealtime
	            			("SubscribeRealtime",
	            			"NFO",					//GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
	            			"NIFTY-I"				//GFDL : NIFTY-I always represents current month Futures. 
	            			));

	            	
	            	//Below request will subscribe to realtime data of NIFTY Futures Contract Expiring on 30JUL2020
	            	//This example shows how to request data using Long Format
	            	//Similarly, you can send FUTIDX_NIFTY_27AUG2020_XX_0 (near month), FUTIDX_NIFTY_24SEP2020_XX_0 (far month). 
	            	//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
	            	//NFO Options Examples : OPTIDX_NIFTY_02JUL2020_CE_10000, OPTSTK_RELIANCE_30JUL2020_CE_1700
	            	//CDS Futures Examples : FUTCUR_USDINR_26JUN2020_XX_0, FUTCUR_USDINR_29JUL2020_XX_0, FUTCUR_USDINR_27AUG2020_XX_0
	            	//CDS Options Examples : OPTCUR_USDINR_29JUL2020_CE_75.5, OPTCUR_EURINR_29JUL2020_CE_80
	            	//MCX Futures Examples : FUTCOM_CRUDEOIL_20JUL2020__0, FUTCOM_CRUDEOIL_19AUG2020__0, FUTCOM_CRUDEOIL_21SEP2020__0
	            	//MCX Options Examples : OPTFUT_CRUDEOIL_16JUL2020_PE_2050, OPTFUT_GOLD_27JUL2020_PE_43700
	            	
	            	//Replace it with appropriate expiry date if this contract is expired
	            	// Please see symbol naming conventions here : 
	            	// https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/
	            	
	                clientEndPoint.sendMessage(SubscribeRealtime
	                		("SubscribeRealtime",
	                		"NFO",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
	                		"FUTIDX_NIFTY_30JUL2020_XX_0"		//GFDL : This is long format symbol of Nifty Futures for Jul 2020 Futures
	                		));
	                
	                
	            	//Below request will subscribe to realtime data of NIFTY Futures Contract Expiring on 30JUL2020
	            	//This example shows how to request data using Contractwise Format
	            	//Similarly, you can send NIFTY20AUGFUT (near month), NIFTY20SEPFUT (far month). 
	            	//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
	            	//NFO Options Examples : NIFTY02JUL2010000CE, RELIANCE30JUL201700CE
	            	//CDS Futures Examples : USDINR20JULFUT, USDINR20AUGFUT, USDINR20SEPFUT
	            	//CDS Options Examples : USDINR29JUL2075.5CE, EURINR29JUL2080CE
	            	//MCX Options Examples : CRUDEOIL20JULFUT, CRUDEOIL20AUGFUT, CRUDEOIL20SEPFUT
	            	//MCX Options Examples : CRUDEOIL20JUL2050PE, GOLD20JUL43700PE
	            	
	            	//Replace it with appropriate expiry date if this contract is expired
	            	// Please see symbol naming conventions here : 
	            	// https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/
	                
	                clientEndPoint.sendMessage(SubscribeRealtime
	                		("SubscribeRealtime",
	                		"NFO",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
	                		"NIFTY20JULFUT"						//GFDL : You can specify Contractwise Symbol like this for Futures of NFO, CDS, MCX
	                		));
	                
	                
	            	//Below request will subscribe to realtime data of "NIFTY 50" Index
	            	//Other Index Examples are "NIFTY BANK", "NIFTY 100" 
	                
	                clientEndPoint.sendMessage(SubscribeRealtime
	                		("SubscribeRealtime",
	                		"NSE_IDX",							//GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
	                		"NIFTY 50"							//GFDL : Please note, there is a the single white space between NIFTY & 50
	                		));

	                
	            	//Below request will subscribe to realtime data of "BAJAJ-AUTO" NSE Stock from EQ Series
	            	//Other Examples are RELIANCE, AXISBANK, LT, etc..
	            	//To subscribe to realtime data of any other series, append the series name to symbol name 
	            	//for example, to request data of RELIANCE CAPITAL from BE Series, use RELCAPITAL.BE
	            	//EQ Series Symbols are mentioned without any suffix
	            	
	                clientEndPoint.sendMessage(SubscribeRealtime
	                		("SubscribeRealtime",
	                		"NSE",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
	                		"BAJAJ-AUTO"						//GFDL : Special Character should be mentioned "as they are" without any additional encoding
	                		));
	                
	                
	            	//Below request will subscribe to realtime data of Current Month Futures of "USDINR" from CDS Exchange
	                clientEndPoint.sendMessage(SubscribeRealtime
	                		("SubscribeRealtime",
	                		"CDS",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
	                		"USDINR-I"							//GFDL : USDINR-I always represents current month Futures. 
	                		));
	                
	                
	            	//Below request will subscribe to realtime data of Current Month Futures of "NATURALGAS" from MCX Exchange
	                clientEndPoint.sendMessage(SubscribeRealtime
	                		("SubscribeRealtime",
	                		"MCX",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
	                		"NATURALGAS-I"						//GFDL : NATURALGAS-I always represents current month Futures. 
	                		));

                    Thread.sleep(120000);
                    break;
	                
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			/* 	GFDL : 	1. 	SubscribeSnapshot : pushes realtime Snapshots as per "Period" and "Periodicity" mentioned. 
			2. 	So you will need to send this request only once and subscribe for the data.
			3.	For example, if Periodicity is "Minute" and "Period" is 1 then server pushes the data of 
			the instrument whenever 1 minute completes.
			4.	Please note that if there is internet disconnection for any reason, you will need to 
			subscribe to all the instruments again - to receive the data.
			5.	To see this function in action, you should run them during market hours
			6.	If you want to subscribe to data of multiple symbols, you will need to send 1 request each - for each symbol
			*/
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	                
                case "SubscribeSnapshot":

                	//Below request will subscribe to snapshot data of Current Month Futures of NIFTY	
                	//This example shows how to request data using Continuous Format
                	//Similarly, you can send NIFTY-II (Near month), NIFTY-III (Far month). 
                	//Below Symbol is Continuous Format of NIFTY Futures. It will never expire. So no change in code will be necessary.
                	//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
                	//CDS Examples : USDINR-I, USDINR-II, USDINR-III
                	//MCX Examples : NATURALGAS-I, NATURALGAS-II, NATURALGAS-III
                	
                	// Please see symbol naming conventions here : 
                	// https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/
                	
                    clientEndPoint.sendMessage(SubscribeSnapshot
                    		("SubscribeSnapshot",
                    		"NFO",								//GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
                    		"NIFTY-I",							//GFDL : NIFTY-I always represents current month Futures. 
                    		"MINUTE",							//GFDL : Supported values are : Minute, Hour
                    		1,									//GFDL : Supported values are : 1,2,5,10,15,30 (for Minute Periodicity ONLY)
                    		"false"								//GFDL : To stop receiving snapshot subscription for this instrument, send value as "true"
                    		));


                	//Below request will subscribe to snapshot data of NIFTY Futures Contract Expiring on 30JUL2020
                	//This example shows how to request data using Long Format
                	//Similarly, you can send FUTIDX_NIFTY_27AUG2020_XX_0 (near month), FUTIDX_NIFTY_24SEP2020_XX_0 (far month). 
                	//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
                	//NFO Options Examples : OPTIDX_NIFTY_02JUL2020_CE_10000, OPTSTK_RELIANCE_30JUL2020_CE_1700
                	//CDS Futures Examples : FUTCUR_USDINR_26JUN2020_XX_0, FUTCUR_USDINR_29JUL2020_XX_0, FUTCUR_USDINR_27AUG2020_XX_0
                	//CDS Options Examples : OPTCUR_USDINR_29JUL2020_CE_75.5, OPTCUR_EURINR_29JUL2020_CE_80
                	//MCX Futures Examples : FUTCOM_CRUDEOIL_20JUL2020__0, FUTCOM_CRUDEOIL_19AUG2020__0, FUTCOM_CRUDEOIL_21SEP2020__0
                	//MCX Options Examples : OPTFUT_CRUDEOIL_16JUL2020_PE_2050, OPTFUT_GOLD_27JUL2020_PE_43700
                	
                	//Replace it with appropriate expiry date if this contract is expired
                	// Please see symbol naming conventions here : 
                	// https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/

                    clientEndPoint.sendMessage(SubscribeSnapshot
                    		("SubscribeSnapshot",
                    		"NFO",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"FUTIDX_NIFTY_30JUL2020_XX_0",		//GFDL : This is long format symbol of Nifty Futures for Jul 2020 Futures
                    		"MINUTE",							//GFDL : Supported values are : Minute, Hour
                    		2,									//GFDL : Supported values are : 1,2,5,10,15,30 (for Minute Periodicity ONLY)
                    		"false"								//GFDL : To stop receiving snapshot subscription for this instrument, send value as "true"
                    		));

                    
                	//Below request will subscribe to snapshot data of NIFTY Futures Contract Expiring on 30JUL2020
                	//This example shows how to request data using Contractwise Format
                	//Similarly, you can send NIFTY20AUGFUT (near month), NIFTY20SEPFUT (far month). 
                	//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
                	//NFO Options Examples : NIFTY02JUL2010000CE, RELIANCE30JUL201700CE
                	//CDS Futures Examples : USDINR20JULFUT, USDINR20AUGFUT, USDINR20SEPFUT
                	//CDS Options Examples : USDINR29JUL2075.5CE, EURINR29JUL2080CE
                	//MCX Options Examples : CRUDEOIL20JULFUT, CRUDEOIL20AUGFUT, CRUDEOIL20SEPFUT
                	//MCX Options Examples : CRUDEOIL20JUL2050PE, GOLD20JUL43700PE
                	
                	//Replace it with appropriate expiry date if this contract is expired
                	// Please see symbol naming conventions here : 
                	// https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/
                    
                    clientEndPoint.sendMessage(SubscribeSnapshot
                    		("SubscribeSnapshot",
                    		"NFO",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"NIFTY20JULFUT",					//GFDL : You can specify Contractwise Symbol like this for Futures of NFO, CDS, MCX
                    		"MINUTE",							//GFDL : Supported values are : Minute, Hour
                    		1,									//GFDL : Supported values are : 1,2,5,10,15,30 (for Minute Periodicity ONLY)
                    		"false"
                    		));
                    
                    
                	//Below request will subscribe to snapshot data of "NIFTY 50" Index
                	//Other Index Examples are "NIFTY BANK", "NIFTY 100" 

                    clientEndPoint.sendMessage(SubscribeSnapshot
                    		("SubscribeSnapshot",
                    		"NSE_IDX",							//GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
                    		"NIFTY 50",							//GFDL : Please note, there is a the single white space between NIFTY & 50
                    		"MINUTE",							//GFDL : Supported values are : Minute, Hour
                    		1,									//GFDL : Supported values are : 1,2,5,10,15,30 (for Minute Periodicity ONLY)
                    		"false"
                    		));

                    
                	//Below request will subscribe to snapshot data of "BAJAJ-AUTO" NSE Stock from EQ Series
                	//Other Examples are RELIANCE, AXISBANK, LT, etc..
                	//To subscribe to realtime data of any other series, append the series name to symbol name 
                	//for example, to request data of RELIANCE CAPITAL from BE Series, use RELCAPITAL.BE
                	//EQ Series Symbols are mentioned without any suffix

                    clientEndPoint.sendMessage(SubscribeSnapshot
                    		("SubscribeSnapshot",
                    		"NSE",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"BAJAJ-AUTO",						//GFDL : Special Character should be mentioned "as they are" without any additional encoding
                    		"MINUTE",							//GFDL : Supported values are : Minute, Hour
                    		1,									//GFDL : Supported values are : 1,2,5,10,15,30 (for Minute Periodicity ONLY)
                    		"false"
                    		));
                    
                    Thread.sleep(180000);
                    break;                


			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			/* 	GFDL : 	1. 	Below 3 functions return the data of SINGLE SYMBOL - whenever requested.
			2. 	So you will need to send these requests EVERY TIME when you need latest data.
			3. 	GetLastQuote : returns single record of realtime data of single symbol. Contains many fields in response
			4. 	GetLastQuoteShort : returns single record of realtime data of single symbol. Contains limited fields in response
			5. 	GetLastQuoteShortWithClose : returns single record of realtime data of single symbol. Contains limited fields in response
			6.	If you want to get data of multiple symbols, you will need to send 1 request each - for each symbol
			
			To know about symbol naming conventions, see SubscribeRealtime / SubscribeSnapshot functions above
			
			Please see symbol naming conventions here : 
			https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/			
			*/
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetLastQuote":
                    clientEndPoint.sendMessage(GetLastQuote
                    		("GetLastQuote",
                    		"NFO",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"NIFTY-I",							
                    		"false"								//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
                    		));									//this argument must be sent with value "true" 
                    Thread.sleep(10000);
                    break;
                    
                case "GetLastQuoteShort":
                    clientEndPoint.sendMessage(GetLastQuoteShort
                    		("GetLastQuoteShort",
                    		"NFO",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"NIFTY-I",
                    		"false"								//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
                    		));									//this argument must be sent with value "true" 
                    Thread.sleep(10000);
                    break;
                    
                case "GetLastQuoteShortWithClose":
                    clientEndPoint.sendMessage(GetLastQuoteShortWithClose
                    		("GetLastQuoteShortWithClose",
                    		"NFO",								//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"NIFTY20JULFUT",
                    		"true"								//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
                    		));									//this argument must be sent with value "true" 
                    Thread.sleep(10000);
                    break;
                    
                    
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			/* 	GFDL : 	1. 	Below 3 functions return the data of MULTIPLE SYMBOLS (MAX 25IN SINGLE CALL) - whenever requested.
			2. 	So you will need to send these requests EVERY TIME when you need latest data.
			3. 	GetLastQuoteArray : returns array of realtime data of multiple symbols. Contains many fields in response
			4. 	GetLastQuoteArrayShort : returns array of realtime data of multiple symbols. Contains limited fields in response
			5. 	GetLastQuoteArrayShortWithClose : returns array of realtime data of multiple symbols. Contains limited fields in response
			6.	If you want to get data of multiple symbols (more than 25), you will need to send more requests - 1 each for 25 symbols
			
			To know about symbol naming conventions, see SubscribeRealtime / SubscribeSnapshot functions above
			
			Please see symbol naming conventions here : 
			https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/			
			*/
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                case "GetLastQuoteArray":
                    clientEndPoint.sendMessage(GetLastQuoteArray("GetLastQuoteArray","NFO","NIFTY-I,BANKNIFTY-I,FINNIFTY-I","false"));
                    Thread.sleep(10000);
                    break;

                case "GetLastQuoteArrayShort":
                    clientEndPoint.sendMessage(GetLastQuoteArrayShort("GetLastQuoteArrayShort","NFO","NIFTY-I,BANKNIFTY-I,FINNIFTY-I","true"));
                    Thread.sleep(10000);
                    break;

                case "GetLastQuoteArrayShortWithClose":
                    clientEndPoint.sendMessage(GetLastQuoteArrayShortWithClose("GetLastQuoteArrayShortwithClose","NFO","NIFTY-I,BANKNIFTY-I,FINNIFTY-I","true"));
                    Thread.sleep(10000);
                    break;

                    
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			/* 	GFDL : 	1. 	GetSnapshot : Returns latest single snapshot of MULTIPLE SYMBOLS (MAX 25 in single call) as per 
			"Periodicity" & "Period" mentioned
			For example, if Periodicity is "Minute" and "Period" is 1 then server will return the data of 
			the requested instrument(s) whenever 1 minute completes.
			2. 	You will need to send this request EVERY TIME when you need latest data.
			3.	To see this function in action, you should run it during market hours				
			
			To know about symbol naming conventions, see SubscribeRealtime / SubscribeSnapshot functions above
			
			Please see symbol naming conventions here : 
			https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/			
			*/
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                case "GetSnapshot":
                    clientEndPoint.sendMessage(GetSnapshot
                    		("GetSnapshot",
                    		"NFO",							//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"NIFTY-I,BANKNIFTY-I,FINNIFTY-I",
                    		"MINUTE",						//GFDL : Supported Values : Minute, Hour
                    		"true",							//GFDL : For Contractwise Instruments, this value should be "true"
                    		1								//GFDL : Supported Values : 1,2,3,5,10,15,20,30
                    		));
                    Thread.sleep(30000);
                    break;

                    
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			
			/* 	GFDL : 	1. 	GetHistory : Returns historical data of SINGLE SYMBOL as per "Periodicity" & "Period" mentioned
			2.	This is a very powerful function which supports many optional parameters to download full / incremental data
			
			To know about symbol naming conventions, see SubscribeRealtime / SubscribeSnapshot functions above
			
			Please see symbol naming conventions here : 
			https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/			
			*/
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			
                case "GetHistory":
                    clientEndPoint.sendMessage(GetHistory
                    		("GetHistory",
                    		"NFO",							//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"NIFTY-I",
                    		"MINUTE",						//GFDL : Supported values are : Tick, Minute, Hour, Day, Week, Month
                    		"false",						//GFDL : When using contractwise symbol like NIFTY20JULFUT,
                    										//this argument must be sent with value "true" 
                    		1,								//GFDL : Supported values : 1,2,3,4,5,10,12,15,20,30
                    		10,								//GFDL : Specify this argument to control the number of records returned.
                    		null                            //For SplitAdust data you need to send as True so then it will delivery you adjusted data by default it will take false when passed by null
                    										//For example, send Max:10 to request only latest 10 records
            				//1579232700,					//Start time of the History as per Epoch time (1st January 1970)
															//Visit https://www.epochconverter.com/ to get formulae to convert human readable 
															//time to Epoch and vice versa (scroll to end of their home page)
							
                    										//If you need entire possible history, send From value as 0
							
                    		//0,							//End time of the History as per Epoch. To request data till latest moment, 
                    										//skip this argument or send time in Future (e.g. current time + 1 hour)
                    		));
                    Thread.sleep(30000);
                    break;

                    
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			/* 	GFDL : 	1. 	GetExchanges : Returns array of Exchanges allowed for your API Key
			*/
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                case "GetExchanges":
                    clientEndPoint.sendMessage(GetExchanges("GetExchanges"));
                    Thread.sleep(5000);
                    break;

                
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetInstrumentsOnSearch();				//GFDL : Returns array of max. 20 instruments by selected exchange and 'search string'
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetInstrumentsOnSearch":
                    clientEndPoint.sendMessage(GetInstrumentsOnSearch
                    		("GetInstrumentsOnSearch",
                    		"NSE",
                    		"TATA"
							//"FUTIDX",		//GFDL : Optional argument to filter the search by products like FUTIDX, FUTSTK, OPTIDX, OPTSTK, 	
											//		 FUTCUR, FUTCOM, etc.
							//"NIFTY",		//GFDL : Optional argument to filter the search by products like NIFTY, RELIANCE, etc.
							//"PE",			//GFDL : Optional argument to filter the search by OptionTypes like CE, PE
							//"30JUL2020",	//GFDL : Optional argument to filter the search by Expiry like 30JUL2020
							//10000, 		//GFDL : Optional argument to filter the search by Strike Price like 10000, 75.5, 1250, etc.
							//"EQ",			//GFDL : Optional argument to filter the search by ProductType like EQ, FUT, OPT, etc.
							//"TRUE",		//GFDL : Optional argument (default=True) to control returned data. If false, even expired contracts are returned
                    		
                    		));
                    Thread.sleep(10000);
                    break;

                
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			/*
			//GetInstruments();						//GFDL : Returns array of instruments by selected exchange 
			
			//VERY VERY IMPORTANT : Huge data of several MB is returned if GetInstruments is called without any optional arguments (NSE & NFO)
			It is strongly advised that users build a local symbol cache at their end and refresh with our server		
			only "on need basis". This will result in faster response time and smoother experience for endusers
			*/
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetInstruments":
                    clientEndPoint.sendMessage(GetInstruments
                    		("GetInstruments",
                    		"NSE"
                    		//"FUTSTK",		//GFDL : Optional argument to filter the search by products like FUTIDX, FUTSTK, OPTIDX, OPTSTK, 	
											//		 FUTCUR, FUTCOM, etc.
							//"NIFTY",		//GFDL : Optional argument to filter the search by products like NIFTY, RELIANCE, etc.
							//"PE",			//GFDL : Optional argument to filter the search by OptionTypes like CE, PE
							//"30JUL2020",	//GFDL : Optional argument to filter the search by Expiry like 30JUL2020
							//10000, 		//GFDL : Optional argument to filter the search by Strike Price like 10000, 75.5, 1250, etc.
							//"EQ",			//GFDL : Optional argument to filter the search by Series like EQ, BE, etc.
							//"FALSE",      //GFDL : Optional parameter. When true, instruments with dummy ISIN will be included in response.(Applicable only for Equity / CASH)
							//"FALSE",      //GFDL : Optional parameter. When true, ETF instruments willbe included in response. (Applicable only for Equity / CASH)
							//"FALSE",      //GFDL : Optional parameter. When true, Inter Operable instruments will be included in response with special character (#/ $).(Applicable only for Equity / CASH)
							//"TRUE",		//GFDL : Optional argument (default=True) to control returned data. If false, even expired contracts are returned
                    		));
                    Thread.sleep(10000);
                    break;

                    
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetInstrumentTypes();					//GFDL : Returns list of Instrument Types (e.g. FUTIDX, FUTSTK, etc.)
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetInstrumentTypes":
                    clientEndPoint.sendMessage(GetInstrumentTypes("GetInstrumentTypes","NFO"));
                    Thread.sleep(10000);
                    break;

                    
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetExpiryDates();						//GFDL : Returns array of Expiry Dates (e.g. 25JUN2020, 30JUL2020, etc.)
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetProducts":
                    clientEndPoint.sendMessage(GetProducts("GetProducts","NFO"));
                    Thread.sleep(10000);
                    break;

                    
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetExpiryDates();						//GFDL : Returns array of Expiry Dates (e.g. 25JUN2020, 30JUL2020, etc.)
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                case "GetExpiryDates":
                    clientEndPoint.sendMessage(GetExpiryDates("GetExpiryDates","NFO"));
                    Thread.sleep(10000);
                    break;

                
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetOptionTypes();			//GFDL : Returns list of Option Types (e.g. CE, PE, etc.)
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetOptionTypes":
                    clientEndPoint.sendMessage(GetOptionTypes("GetOptionTypes","MCX"));
                    Thread.sleep(10000);
                    break;

                
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetStrikePrices();		//GFDL : Returns list of Strike Prices (e.g. 10000, 11000, 75.5, etc.)
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetStrikePrices":
                    clientEndPoint.sendMessage(GetStrikePrices("GetStrikePrices","MCX"));
                    Thread.sleep(10000);
                    break;

                
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetServerInfo();			//GFDL : Returns the server endpoint where user is connected
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetServerInfo":
                    clientEndPoint.sendMessage(GetServerInfo("GetServerInfo"));
                    Thread.sleep(5000);
                    break;

                
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetLimitation();			//GFDL : Returns user account information (functions allowed, Exchanges allowed, symbol limit, etc.)
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetLimitation":
                    clientEndPoint.sendMessage(GetLimitation("GetLimitation"));
                    Thread.sleep(5000);
                    break;

                
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetMarketMessages();					//GFDL : Returns array of last messages (Market Messages) related to selected exchange
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetMarketMessages":
                    clientEndPoint.sendMessage(GetMarketMessages("GetMarketMessages","NSE"));
                    Thread.sleep(10000);
                    break;

                
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetExchangeMessages();				//GFDL : Returns array of last messages (Exchange Messages) related to selected exchange
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetExchangeMessages":
                    clientEndPoint.sendMessage(GetExchangeMessages("GetExchangeMessages","NSE"));
                    Thread.sleep(10000);
                    break;

                    
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetLastQuoteOptionChain();			//GFDL : Returns OptionChain data in realtime
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                case "GetLastQuoteOptionChain":
                    clientEndPoint.sendMessage(GetLastQuoteOptionChain
                    		("GetLastQuoteOptionChain",
                    		"NFO",
                    		"RELIANCE"
            				//Expiry: "23JAN2020",			//GFDL : Optional field, in DDMMMYYYY format. If absent, result is sent for all active Expiries
            				//OptionType: "CE",				//GFDL : Optional field, CE or PE. If absent, result is sent for all Option Types
            				//StrikePrice: 10000			//GFDL : Optional field, as a number. If absent, result is sent for all strike prices
                    		));
                    Thread.sleep(30000);
                    break;
                    
                    
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//GetExchangeSnapshot();				//GFDL : Returns entire Exchange Snapshot in realtime
			// This function can return maximum 5 snapshots in single call. You will need to
			// use "From" and "To" parameters to control the dataset required
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                    
                case "GetExchangeSnapshot":
                    clientEndPoint.sendMessage(GetExchangeSnapshot
                    		("GetExchangeSnapshot",
                    		"NFO",
                    		"Minute",
                    		1
							        					//InstrumentType: FUTIDX,	//GFDL : Optional Parameter. FUTIDX, FUTSTK, OPTIDX, OPTSTK, FUTCOM, FUTCUR, etc. 
														//If not mentioned, results are sent for all instrument types
							//1567655100,				//GFDL : Epoch value of time in seconds since 1st January 1970. For example, 1567655100 is 
														//epoch value for Thursday, September 5, 2019 9:15:00 AM in GMT+05:30 timezone. 
														//Optional field to control snapshot start time.
							//1567655400,				//GFDL : Epoch value of time in seconds since 1st January 1970. For example, 1567655100 is 
														//epoch value for Thursday, September 5, 2019 9:15:00 AM in GMT+05:30 timezone. 
														//Optional field to control snapshot end time.
							//"true"					//GFDL : true/false. When true, results are sent with data of even non traded instruments. 
														//When false, data of only traded instruments during that period is sent 
														//Optional, default value is "false"
                    		));
                    Thread.sleep(30000);
                    break;
                    
                case "SubscribeOptionChain":
                    clientEndPoint.sendMessage(SubscribeOptionChain
                    		("SubscribeOptionChain",
                    		"NFO",
                    		"NIFTY",
            				"12SEP2024",			//GFDL : Optional field, in DDMMMYYYY format. If absent, result is sent for all active Expiries
            				 "CE",				//GFDL : Optional field, CE or PE. If absent, result is sent for all Option Types
            				"25200",			//GFDL : Optional field, as a number. If absent, result is sent for all strike prices
            				5,
            				"False"
                    		));
                    Thread.sleep(30000);
                    break;
                case "SubscribeOptionChainGreeks":
                    clientEndPoint.sendMessage(SubscribeOptionChainGreeks
                    		("SubscribeOptionChainGreeks",
                    		"NFO",
                    		"NIFTY",
            				"12SEP2024",			//GFDL : Optional field, in DDMMMYYYY format. If absent, result is sent for all active Expiries
            				 "CE",				//GFDL : Optional field, CE or PE. If absent, result is sent for all Option Types
            				"25200",			//GFDL : Optional field, as a number. If absent, result is sent for all strike prices
            				5,
            				"False"
                    		));
                    Thread.sleep(30000);
                    break;
                case "GetLastQuoteOptionGreeks":
                    clientEndPoint.sendMessage(GetLastQuoteOptionGreeks
                    		("GetLastQuoteOptionGreeks",
                    		"NFO",
                    		52534
                    		));
                    Thread.sleep(30000);
                    break;
                case "GetLastQuoteArrayOptionGreeks":
                    clientEndPoint.sendMessage(GetLastQuoteArrayOptionGreeks
                    		("GetLastQuoteArrayOptionGreeks",
                    		"NFO",
                    		"40662,50311"
                    		));
                    Thread.sleep(30000);
                    break;
                case "GetLastQuoteOptionGreeksChain":
                    clientEndPoint.sendMessage(GetLastQuoteOptionGreeksChain
                    		("GetLastQuoteOptionGreeksChain",
                    		"NFO",
                    		"NIFTY",
            				"12SEP2024",			//GFDL : Optional field, in DDMMMYYYY format. If absent, result is sent for all active Expiries
            				 "CE",				//GFDL : Optional field, CE or PE. If absent, result is sent for all Option Types
            				"25200"
                    		));
                    Thread.sleep(30000);
                    break;
                case "SubscribeRealtimeGreeks":
                    clientEndPoint.sendMessage(SubscribeRealtimeGreeks
                    		("SubscribeRealtimeGreeks",
                    		"NFO",
                    		52534,
                    		"false"
                    		));
                    Thread.sleep(30000);
                    break;
				case "SubscribeSnapshotGreeks":
					clientEndPoint.sendMessage(SubscribeSnapshotGreeks
								("SubscribeSnapshotGreeks",
								"NFO",								//GFDL : Supported Values : NFO Mandatory Parameter
								"NIFTY25NOV2525000CE",						//GFDL : Special Character should be mentioned "as they are" without any additional encoding
								"MINUTE",							//GFDL : Supported values are : Minute
								1,									//GFDL : Supported values are : 1
								"false"
								));
						
					Thread.sleep(180000);
					break;   
				case "GetSnapshotGreeks":
                    clientEndPoint.sendMessage(GetSnapshotGreeks
                    		("GetSnapshotGreeks",
                    		"NFO",							//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"NIFTY25NOV2525000CE,NIFTY25NOV2525000PE,BANKNIFTY25NOV2580000CE",
                    		"MINUTE",						//GFDL : Supported Values : Minute
                    		"true",							//GFDL : For Contractwise Instruments, this value should be "true"
                    		1								//GFDL : Supported Values : 1
                    		));
                    Thread.sleep(30000);
                    break;
                case "SubscribeTopGainersLosers":
                    clientEndPoint.sendMessage(SubscribeTopGainersLosers
                    		("SubscribeTopGainersLosers",
                    		"NFO",
                    		5,
                    		"false"
                    		));
                    Thread.sleep(30000);
                    break;
                case "GetTopGainersLosers":
                    clientEndPoint.sendMessage(GetTopGainersLosers
                    		("GetTopGainersLosers",
                    		"NFO",
                    		5
                    		));
                    Thread.sleep(30000);
                    break;
				case "GetVolumeShockers":
                    clientEndPoint.sendMessage(GetVolumeShockers
                    		("GetVolumeShockers",
                    		"NSE",
                    		5,
							"EQ"
                    		));
                    Thread.sleep(30000);
                    break;
                case "GetHistoryGreeks":
                    clientEndPoint.sendMessage(GetHistoryGreeks
                    		("GetHistoryGreeks",
                    		"NFO",							//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
                    		"NIFTY12SEP2425200CE",                    							
                    		"true",						//GFDL : When using contractwise symbol like NIFTY20JULFUT,this argument must be sent with value "true"                   										
                    		
                    		10,								//GFDL : Specify this argument to control the number of records returned.
                    		                           //For SplitAdust data you need to send as True so then it will delivery you adjusted data by default it will take false when passed by null
                    										//For example, send Max:10 to request only latest 10 records
            				0,					//Start time of the History as per Epoch time (1st January 1970)
															//Visit https://www.epochconverter.com/ to get formulae to convert human readable 
															//time to Epoch and vice versa (scroll to end of their home page)
							
                    										//If you need entire possible history, send From value as 0
							
                    		0							//End time of the History as per Epoch. To request data till latest moment, 
                    										//skip this argument or send time in Future (e.g. current time + 1 hour)
                    		));
                    Thread.sleep(30000);
                    break;
                default:
                    break;
            }
        }
        else
        {
            System.out.println("Connection Failed. Try again...");
        }
     }
    
    private static String getAuthenticate(String msgType, String message) {
        return Json.createObjectBuilder().add("MessageType", msgType).add("Password", message).build().toString();
    }
        
    private static String SubscribeRealtime(String msgType,
            String ExchangeName,
            String InstIdentifier) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", InstIdentifier)
                .build().toString();
    }
    
    private static String SubscribeSnapshot(String msgType,
            String ExchangeName,
            String InstIdentifier,
            String Periodicity,
            int	Period,
            String Unsubscribe) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", InstIdentifier)
                .add("Periodicity", Periodicity)
                .add("Period", Period)
                .add("Unsubscribe", Unsubscribe)
                .build().toString();
    }

    private static String GetLastQuote(String msgType,
            String ExchangeName,
            String InstIdentifier,
            String isShortIdentifier) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", InstIdentifier)
                .add("isShortIdentifier", isShortIdentifier)
                .build().toString();
    }
    
    private static String GetLastQuoteShort(String msgType,
            String ExchangeName,
            String InstIdentifier,
            String isShortIdentifier) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", InstIdentifier)
                .add("isShortIdentifier", isShortIdentifier)
                .build().toString();
    }
    
    private static String GetLastQuoteShortWithClose(String msgType,
            String ExchangeName,
            String InstIdentifier,
            String isShortIdentifier) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", InstIdentifier)
                .add("isShortIdentifier", isShortIdentifier)
                .build().toString();
    }
    
    private static String GetLastQuoteArray(String msgType,
            String ExchangeName,
            String InstrumentIdentifiers,
            String isShortIdentifiers) {
//        String lstInst = "{\"Value\":\"NIFTY20JULFUT\"},{\"Value\":\"BANKNIFTY20JULFUT\"},{\"Value\":\"RELIANCE20JULFUT\"}";
	    	// Split the InstrumentIdentifiers string by commas
	        String[] identifiersArray = InstrumentIdentifiers.split(",");
	
	        // Use StringBuilder to construct lstInst
	        StringBuilder lstInstBuilder = new StringBuilder();
	
	        for (int i = 0; i < identifiersArray.length; i++) {
	            lstInstBuilder.append("{\"Value\":\"").append(identifiersArray[i]).append("\"}");
	            if (i < identifiersArray.length - 1) {
	                lstInstBuilder.append(",");
	            }
	        }

        String lstInst = lstInstBuilder.toString();
        String strreq = "{\"MessageType\":\"GetLastQuoteArray\",\"Exchange\":\"" + ExchangeName + "\",\"InstrumentIdentifiers\":[" + lstInst + "],\"isShortIdentifiers\":\"" + isShortIdentifiers + "\"}";
        /*return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", "[" + lstInst + "]")
                .build().toString();*/
        return strreq;
    }

    private static String GetLastQuoteArrayShort(String msgType,
            String ExchangeName,
            String InstrumentIdentifiers,
            String isShortIdentifiers) {
//        String lstInst = "{\"Value\":\"NIFTY20JULFUT\"},{\"Value\":\"BANKNIFTY20JULFUT\"},{\"Value\":\"RELIANCE20JULFUT\"}";
    	// Split the InstrumentIdentifiers string by commas
        String[] identifiersArray = InstrumentIdentifiers.split(",");

        // Use StringBuilder to construct lstInst
        StringBuilder lstInstBuilder = new StringBuilder();

        for (int i = 0; i < identifiersArray.length; i++) {
            lstInstBuilder.append("{\"Value\":\"").append(identifiersArray[i]).append("\"}");
            if (i < identifiersArray.length - 1) {
                lstInstBuilder.append(",");
            }
        }

        String lstInst = lstInstBuilder.toString();
        String strreq = "{\"MessageType\":\"GetLastQuoteArray\",\"Exchange\":\"" + ExchangeName + "\",\"InstrumentIdentifiers\":[" + lstInst + "],\"isShortIdentifiers\":\"" + isShortIdentifiers + "\"}";
        /*return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", "[" + lstInst + "]")
                .build().toString();*/
        return strreq;
    }

    private static String GetLastQuoteArrayShortWithClose(String msgType,
            String ExchangeName,
            String InstrumentIdentifiers,
            String isShortIdentifiers) {
//        String lstInst = "{\"Value\":\"NIFTY20JULFUT\"},{\"Value\":\"BANKNIFTY20JULFUT\"},{\"Value\":\"RELIANCE20JULFUT\"}";
    	// Split the InstrumentIdentifiers string by commas
        String[] identifiersArray = InstrumentIdentifiers.split(",");

        // Use StringBuilder to construct lstInst
        StringBuilder lstInstBuilder = new StringBuilder();

        for (int i = 0; i < identifiersArray.length; i++) {
            lstInstBuilder.append("{\"Value\":\"").append(identifiersArray[i]).append("\"}");
            if (i < identifiersArray.length - 1) {
                lstInstBuilder.append(",");
            }
        }

        String lstInst = lstInstBuilder.toString();
        String strreq = "{\"MessageType\":\"GetLastQuoteArray\",\"Exchange\":\"" + ExchangeName + "\",\"InstrumentIdentifiers\":[" + lstInst + "],\"isShortIdentifiers\":\"" + isShortIdentifiers + "\"}";
        /*return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", "[" + lstInst + "]")
                .build().toString();*/
        return strreq;
    }

    private static String GetSnapshot(String msgType,
            String ExchangeName,
            String InstrumentIdentifiers,
            String Periodicity,
            String isShortIdentifiers,
            int Period) {
    	// Split the InstrumentIdentifiers string by commas
        String[] identifiersArray = InstrumentIdentifiers.split(",");

        // Use StringBuilder to construct lstInst
        StringBuilder lstInstBuilder = new StringBuilder();

        for (int i = 0; i < identifiersArray.length; i++) {
            lstInstBuilder.append("{\"Value\":\"").append(identifiersArray[i]).append("\"}");
            if (i < identifiersArray.length - 1) {
                lstInstBuilder.append(",");
            }
        }

        String lstInst = lstInstBuilder.toString();
        String strreq = "{\"MessageType\":\"GetSnapshot\",\"Exchange\":\"" + ExchangeName + "\",\"Periodicity\":\"" + Periodicity + "\",\"InstrumentIdentifiers\":[" + lstInst + "],\"Period\":"+ Period + ",\"isShortIdentifiers\":\"" + isShortIdentifiers + "\"}";  	
       	/* return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifiers", InstIdentifiers)
                .add("Periodicity", Periodicity)
                .add("isShortIdentifiers", isShortIdentifiers)
                .add("Period", Period)
                .build().toString(); */
        return strreq;
    }

    
    private static String GetHistory(String msgType,
            String ExchangeName,
            String InstIdentifier,
            String Periodicity,
            String isShortIdentifier,
            int Period,
            int Max,
            String AdjustSplits) {
    if (AdjustSplits == null || AdjustSplits.isEmpty()) {
        AdjustSplits = "false";  // Default to "false"
    }
   
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", InstIdentifier)
                .add("Periodicity", Periodicity)
                .add("isShortIdentifier", isShortIdentifier)
                .add("Period", Period)
                .add("Max", Max)
                .add("AdjustSplits", AdjustSplits)
                .build().toString();
    }
    
    private static String GetExchanges(String msgType) {
        return Json.createObjectBuilder().add("MessageType", msgType).build().toString();
    }
    
    private static String GetInstrumentsOnSearch(String msgType,
            String ExchangeName,
            String Search) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Search", Search)
                .build().toString();
    }

    private static String GetServerInfo(String msgType) {
        return Json.createObjectBuilder().add("MessageType", msgType).build().toString();
    }
    
    private static String GetLimitation(String msgType) {
        return Json.createObjectBuilder().add("MessageType", msgType).build().toString();
    }
    
    private static String GetMarketMessages(String msgType,
    		String ExchangeName) {
        return Json.createObjectBuilder().add("MessageType", msgType)
        		.add("Exchange", ExchangeName)
                .build().toString();
    }
    
    private static String GetExchangeMessages(String msgType,
    		String ExchangeName) {
        return Json.createObjectBuilder().add("MessageType", msgType)
        		.add("Exchange", ExchangeName)
                .build().toString();
    }
    
    private static String GetStrikePrices(String msgType,String ExchangeName) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .build().toString();
    }
    
    private static String GetOptionTypes(String msgType,String ExchangeName) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .build().toString();
    }
    
    private static String GetExpiryDates(String msgType,String ExchangeName) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .build().toString();
    }
    
    private static String GetProducts(String msgType,String ExchangeName) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .build().toString();
    }
    
    private static String GetInstrumentTypes(String msgType,String ExchangeName) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .build().toString();
    }
    
    private static String GetInstruments(String msgType,String ExchangeName) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .build().toString();
    }    
    
    private static String GetLastQuoteOptionChain(String msgType,
    		String ExchangeName,
    		String Product) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Product", Product)
                .build().toString();
    }
    private static String GetLastQuoteOptionGreeks(String msgType,
    		String ExchangeName,
    		int Token) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Token", Token)
                .build().toString();
    }
    private static String GetLastQuoteArrayOptionGreeks(String msgType,
    		String ExchangeName,
    		String Token) {
    	String[] identifiersArray = Token.split(",");

        // Use StringBuilder to construct lstInst
        StringBuilder lstInstBuilder = new StringBuilder();

        for (int i = 0; i < identifiersArray.length; i++) {
            lstInstBuilder.append("{\"Value\":\"").append(identifiersArray[i]).append("\"}");
            if (i < identifiersArray.length - 1) {
                lstInstBuilder.append(",");
            }
        }

        String lstInst = lstInstBuilder.toString();
        String strreq = "{\"MessageType\":\"GetLastQuoteArrayOptionGreeks\",\"Exchange\":\"" + ExchangeName + "\",\"Tokens\":[" + lstInst + "]}";  	
       	
        return strreq;
//        return Json.createObjectBuilder().add("MessageType", msgType)
//                .add("Exchange", ExchangeName)
//                .add("Tokens", lstInst)
//                .build().toString();
    }
    private static String GetLastQuoteOptionGreeksChain(String msgType,String ExchangeName,String Product,String Expiry,String  OptionType,String StrikePrice) 
    {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Product", Product)                
                .add("Expiry",Expiry)
                .add("OptionType",OptionType)
                .add("StrikePrice",StrikePrice)
                
                
                .build().toString();
    }
    private static String SubscribeRealtimeGreeks(String msgType,
    		String ExchangeName,
    		int Token,
    		String Unsubscribe) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Token", Token)
                .add("Unsubscribe", Unsubscribe)
                .build().toString();
    }
	private static String SubscribeSnapshotGreeks(String msgType,
            String ExchangeName,
            String InstIdentifier,
            String Periodicity,
            int	Period,
            String Unsubscribe) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifier", InstIdentifier)
                .add("Periodicity", Periodicity)
                .add("Period", Period)
                .add("Unsubscribe", Unsubscribe)
                .build().toString();
    }
	private static String GetSnapshotGreeks(String msgType,
            String ExchangeName,
            String InstrumentIdentifiers,
            String Periodicity,
            String isShortIdentifiers,
            int Period) {
    	// Split the InstrumentIdentifiers string by commas
        String[] identifiersArray = InstrumentIdentifiers.split(",");

        // Use StringBuilder to construct lstInst
        StringBuilder lstInstBuilder = new StringBuilder();

        for (int i = 0; i < identifiersArray.length; i++) {
            lstInstBuilder.append("{\"Value\":\"").append(identifiersArray[i]).append("\"}");
            if (i < identifiersArray.length - 1) {
                lstInstBuilder.append(",");
            }
        }

        String lstInst = lstInstBuilder.toString();
        String strreq = "{\"MessageType\":\"GetSnapshot\",\"Exchange\":\"" + ExchangeName + "\",\"Periodicity\":\"" + Periodicity + "\",\"InstrumentIdentifiers\":[" + lstInst + "],\"Period\":"+ Period + ",\"isShortIdentifiers\":\"" + isShortIdentifiers + "\"}";  	
       	/* return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("InstrumentIdentifiers", InstIdentifiers)
                .add("Periodicity", Periodicity)
                .add("isShortIdentifiers", isShortIdentifiers)
                .add("Period", Period)
                .build().toString(); */
        return strreq;
    }
    private static String SubscribeOptionChain(String msgType,String ExchangeName,String Product,String Expiry,String  OptionType,String StrikePrice,int Depth,String Unsubscribe) 
    {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Product", Product)
                .add("Unsubscribe", Unsubscribe)
                .add("Expiry",Expiry)
                .add("OptionType",OptionType)
                .add("StrikePrice",StrikePrice)
                .add("Depth",Depth)
                
                .build().toString();
    }
    private static String SubscribeOptionChainGreeks(String msgType,String ExchangeName,String Product,String Expiry,String  OptionType,String StrikePrice,int Depth,String Unsubscribe) 
    {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Product", Product)
                .add("Unsubscribe", Unsubscribe)
                .add("Expiry",Expiry)
                .add("OptionType",OptionType)
                .add("StrikePrice",StrikePrice)
                .add("Depth",Depth)
                
                .build().toString();
    }
    private static String SubscribeTopGainersLosers(String msgType,
    		String ExchangeName,
    		int Count,
    		String Unsubscribe) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Count", Count)
                .add("Unsubscribe", Unsubscribe)
                .build().toString();
    }
    private static String GetTopGainersLosers(String msgType,
    		String ExchangeName,
    		int Count) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Count", Count)
                
                .build().toString();
    }
	private static String GetVolumeShockers(String msgType,
    		String ExchangeName,
    		int Count,
			String Series) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Count", Count)				
				.add("Series", Series)
                
                .build().toString();
    }

    
    private static String GetHistoryGreeks(String msgType,
            String ExchangeName,
            String InstIdentifier,
            String isShortIdentifier,
            int Max,
            int From,
            int To) {

		// Start building the JSON object
		JsonObjectBuilder jsonBuilder = Json.createObjectBuilder()
				.add("MessageType", msgType)
				.add("Exchange", ExchangeName)
				.add("InstrumentIdentifier", InstIdentifier)
				.add("isShortIdentifier", isShortIdentifier)
				.add("Max", Max);
				
				// Conditionally add "From" if it's not 0
				if (From != 0) {
				jsonBuilder.add("From", From);
				}
				
				// Conditionally add "To" if it's not 0
				if (To != 0) {
				jsonBuilder.add("To", To);
				}
				
				// Build and return the JSON string
		return jsonBuilder.build().toString();
		}
    private static String GetExchangeSnapshot(String msgType,
    		String ExchangeName,
    		String Periodicity,
    		int Period) {
        return Json.createObjectBuilder().add("MessageType", msgType)
                .add("Exchange", ExchangeName)
                .add("Periodicity", Periodicity)
                .add("Period", Period)
                .build().toString();
    }
    
}
