var websocketClient = require('websocket').client;
var client = new websocketClient();

/*
GFDL TODO - please enter below the endpoint received from GFDL team. 
If you dont have one, please contact us on sales@globaldatafeeds.in 
*/
var endpoint = "ws://test.lisuns.com:4575//";


/*
//GFDL TODO - please enter below the API Key received from GFDL team. 
If you dont have one, please contact us on sales@globaldatafeeds.in 
*/
var accesskey = "0aca689c-2001-4f54-b7a1-d84aec36099a";

var output;


client.on('connectFailed', function(error){
	console.log('Connection Error: ' + error.toString());
});

client.on('connect', function(connection){
	var AuthConnect = false;
	var callDone = false;
	
	console.log('Client Connected!');
	Authenticate();
	connection.on('error',function(error){
		console.log('Connection Error: ' + error.toString());
	});
	connection.on('close', function() {
        console.log('echo-protocol Connection Closed');
    });
	connection.on('message', function(message) {
		//setTimeout(doClose, 120000);
		if (message.type === 'utf8') {
			AuthConnect = true;	
            console.log("Received: '" + message.utf8Data + "'");
			if(callDone == false)
			{
				setTimeout(functionCall, 2000);
				callDone = true;
			}
        }
    });
	
	function doClose()
	{
      connection.close();
	}
  
	function callAPI(request){
		console.log("request: *****" + request + "*****");
		if (connection.connected) {
            connection.sendUTF(request);
        }
	}
	function Authenticate() {
		
        if (connection.connected) {
            strMessage = '{"MessageType":"Authenticate","Password":"' + accesskey + '"}'
			callAPI(strMessage);
        }
    }

	//GFDL TODO : All the functions supported by API are listed below. 
	//You can uncomment any function to see the flow of request and response
	function functionCall()
	{
	// SubscribeRealtime();					//GFDL : Subscribes to realtime data (server will push new data whenever available)
	//SubscribeSnapshot();					//GFDL : Subscribes to minute snapshot data (server will push new data whenever available)

	//GetLastQuote();						//GFDL : Returns LastTradePrice of Single Symbol (detailed)
	//GetLastQuoteShort();					//GFDL : Returns LastTradePrice of Single Symbol (short)
	//GetLastQuoteShortWithClose();			//GFDL : Returns LastTradePrice of Single Symbol (short) with Close of Previous Day
	GetLastQuoteArray();					//GFDL : Returns LastTradePrice of multiple Symbols – max 25 in single call (detailed)
	//GetLastQuoteArrayShort();				//GFDL : Returns LastTradePrice of multiple Symbols – max 25 in single call (short)
	//GetLastQuoteArrayShortWithClose();	//GFDL : Returns LastTradePrice of multiple Symbols – max 25 in single call (short) with Previous Close

	//GetSnapshot();						//GFDL : Returns latest Snapshot Data of multiple Symbols – max 25 in single call
	//GetHistory();							//GFDL : Returns historical data (Tick / Minute / EOD)

	//GetExchanges();						//GFDL : Returns array of available exchanges configured for API Key

	//GetInstrumentsOnSearch();				//GFDL : Returns array of max. 20 instruments by selected exchange and 'search string'
	//GetInstruments();						//GFDL : Returns array of instruments by selected exchange 

	//GetInstrumentTypes();					//GFDL : Returns list of Instrument Types (e.g. FUTIDX, FUTSTK, etc.)
	//GetProducts();						//GFDL : Returns list of Products (e.g. NIFTY, BANKNIFTY, GAIL, etc.)
	//GetExpiryDates();						//GFDL : Returns array of Expiry Dates (e.g. 25JUN2020, 30JUL2020, etc.)
	//GetOptionTypes();						//GFDL : Returns list of Option Types (e.g. CE, PE, etc.)
	//GetStrikePrices();					//GFDL : Returns list of Strike Prices (e.g. 10000, 11000, 75.5, etc.)

	//GetServerInfo();						//GFDL : Returns the server endpoint where user is connected
	//GetLimitation();						//GFDL : Returns user account information (functions allowed, Exchanges allowed, symbol limit, etc.)

	//GetMarketMessages();					//GFDL : Returns array of last messages (Market Messages) related to selected exchange
	//GetExchangeMessages();				//GFDL : Returns array of last messages (Exchange Messages) related to selected exchange

	//GetLastQuoteOptionChain();			//GFDL : Returns OptionChain data in realtime
	//GetExchangeSnapshot();				//GFDL : Returns entire Exchange Snapshot in realtime
	
	// GetLastQuoteOptionGreeks();			//GFDL : Returns Last Traded Option Greek values of Single Symbol (detailed)
	// GetLastQuoteArrayOptionGreeks();		//GFDL : Returns Last Traded Option Greek values of multiple Symbols – max 25 in single call (detailed) 
	// GetLastQuoteOptionGreeksChain();		//GFDL : Returns Last Traded Option Greek values of entire OptionChain of requested underlying	
	//GetExchangeSnapshotAfterMarket();		//GFDL : Returns entire Exchange Snapshot after market.

	//SubscribeRealtimeGreeks();
	//SubscribeSnapshotGreeks();
	//GetSnapshotGreeks();
	//SubscribeOptionChain();
	//SubscribeOptionChainGreeks();
	//SubscribeTopGainersLosers();
	//GetTopGainersLosers();               //GFDL: Return the data top ganiner and losers at the requested time.
	//GetVolumeShockers();                //GFDL: Returns the volume shockers data at the requested time.
	//GetHistoryGreeks();                  //GFDL:Returns historical data of SINGLE SYMBOL as per "Periodicity" & "Period" mentioned
	}

		functionCall();
	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/* 	GFDL : 	1. 	SubscribeRealtime : pushes realtime data every second for the subscribed instrument from server
				2. 	So you will need to send this request only once and subscribe for the data.	
				3.	Please note that if there is internet disconnection for any reason, you will need to 
					subscribe to all the instruments again - to receive the data.
				4.	To see this function in action, you should run it during market hours
				5.	If you want to subscribe to data of multiple symbols, you will need to send 1 request each - for each symbol
				6. 	Please see symbol naming conventions here : https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/
	*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
Subscribing to realtime data of Futures & Options :
---------------------------------------------------
//Below request will subscribe to realtime data of Current Month Futures of NIFTY	
//This example shows how to request data using Continuous Format
//Similarly, you can send NIFTY-II (Near month), NIFTY-III (Far month). 
//Below Symbol is Continuous Format of NIFTY Futures. It will never expire. So no change in code will be necessary.
//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
//CDS Examples : USDINR-I, USDINR-II, USDINR-III
//MCX Examples : NATURALGAS-I, NATURALGAS-II, NATURALGAS-III

//Similarly, you can send NIFTY20AUGFUT (near month), NIFTY20SEPFUT (far month). 
//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
//NFO Options Examples : NIFTY02JUL2010000CE, RELIANCE30JUL201700CE
//CDS Futures Examples : USDINR20JULFUT, USDINR20AUGFUT, USDINR20SEPFUT
//CDS Options Examples : USDINR29JUL2075.5CE, EURINR29JUL2080CE
//MCX Options Examples : CRUDEOIL20JULFUT, CRUDEOIL20AUGFUT, CRUDEOIL20SEPFUT
//MCX Options Examples : CRUDEOIL20JUL2050PE, GOLD20JUL43700PE	
//Important : Replace it with appropriate expiry date if this contract is expired

//Similarly, you can send FUTIDX_NIFTY_27AUG2020_XX_0 (near month), FUTIDX_NIFTY_24SEP2020_XX_0 (far month). 
//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
//NFO Options Examples : OPTIDX_NIFTY_02JUL2020_CE_10000, OPTSTK_RELIANCE_30JUL2020_CE_1700
//CDS Futures Examples : FUTCUR_USDINR_26JUN2020_XX_0, FUTCUR_USDINR_29JUL2020_XX_0, FUTCUR_USDINR_27AUG2020_XX_0
//CDS Options Examples : OPTCUR_USDINR_29JUL2020_CE_75.5, OPTCUR_EURINR_29JUL2020_CE_80
//MCX Futures Examples : FUTCOM_CRUDEOIL_20JUL2020__0, FUTCOM_CRUDEOIL_19AUG2020__0, FUTCOM_CRUDEOIL_21SEP2020__0
//MCX Options Examples : OPTFUT_CRUDEOIL_16JUL2020_PE_2050, OPTFUT_GOLD_27JUL2020_PE_43700
//Important : Replace it with appropriate expiry date if this contract is expired

Subscribing to realtime data of NSE Indices
-------------------------------------------
//Use InstrumentIdenfier value "NIFTY 50", "NIFTY BANK", "NIFTY 100", etc.
//Use NSE_IDX as Exchange
//Please note that Indices Symbols have white space. For example, between NIFTY & 50, NIFTY & BANK above

Subscribing to realtime data of NSE Stocks 
------------------------------------------
//For EQ Series, use InstrumentIdentifier value BAJAJ-AUTO, RELIANCE, AXISBANK, LT, etc..
//To subscribe to realtime data of any other series, append the series name to symbol name 
//for example, to request data of RELIANCE CAPITAL from BE Series, use RELCAPITAL.BE
//EQ Series Symbols are mentioned without any suffix

// Please see symbol naming conventions here : 
// https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/
*/

function SubscribeRealtime()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";				//GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
		var InstIdentifier = "NIFTY-I";			//GFDL : NIFTY-I always represents current month Futures. 
		request = '{"MessageType":"SubscribeRealtime","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/* 	GFDL : 	1. 	SubscribeSnapshot : pushes realtime Snapshots as per "Period" and "Periodicity" mentioned. 
				2. 	So you will need to send this request only once and subscribe for the data.
				3.	For example, if Periodicity is "Minute" and "Period" is 1 then server pushes the data of 
					the instrument whenever 1 minute completes.
				4.	Please note that if there is internet disconnection for any reason, you will need to 
					subscribe to all the instruments again - to receive the data.
				5.	To see this function in action, you should run them during market hours
				6.	If you want to subscribe to data of multiple symbols, you will need to send 1 request each - for each symbol
	*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*
	//Below request will subscribe to snapshot data of Current Month Futures of NIFTY	
	//This example shows how to request data using Continuous Format
	//Similarly, you can send NIFTY-II (Near month), NIFTY-III (Far month). 
	//Below Symbol is Continuous Format of NIFTY Futures. It will never expire. So no change in code will be necessary.
	//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
	//CDS Examples : USDINR-I, USDINR-II, USDINR-III
	//MCX Examples : NATURALGAS-I, NATURALGAS-II, NATURALGAS-III
	
	//Below request will subscribe to snapshot data of NIFTY Futures Contract Expiring on 30JUL2020
	//This example shows how to request data using Contractwise Format
	//Similarly, you can send NIFTY20AUGFUT (near month), NIFTY20SEPFUT (far month). 
	//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
	//NFO Options Examples : NIFTY02JUL2010000CE, RELIANCE30JUL201700CE
	//CDS Futures Examples : USDINR20JULFUT, USDINR20AUGFUT, USDINR20SEPFUT
	//CDS Options Examples : USDINR29JUL2075.5CE, EURINR29JUL2080CE
	//MCX Options Examples : CRUDEOIL20JULFUT, CRUDEOIL20AUGFUT, CRUDEOIL20SEPFUT
	//MCX Options Examples : CRUDEOIL20JUL2050PE, GOLD20JUL43700PE	
	//Replace it with appropriate expiry date if this contract is expired

	//Similarly, you can send FUTIDX_NIFTY_27AUG2020_XX_0 (near month), FUTIDX_NIFTY_24SEP2020_XX_0 (far month). 
	//You can use same naming convention for Futures of Instruments from NFO, CDS, MCX Exchanges
	//NFO Options Examples : OPTIDX_NIFTY_02JUL2020_CE_10000, OPTSTK_RELIANCE_30JUL2020_CE_1700
	//CDS Futures Examples : FUTCUR_USDINR_26JUN2020_XX_0, FUTCUR_USDINR_29JUL2020_XX_0, FUTCUR_USDINR_27AUG2020_XX_0
	//CDS Options Examples : OPTCUR_USDINR_29JUL2020_CE_75.5, OPTCUR_EURINR_29JUL2020_CE_80
	//MCX Futures Examples : FUTCOM_CRUDEOIL_20JUL2020__0, FUTCOM_CRUDEOIL_19AUG2020__0, FUTCOM_CRUDEOIL_21SEP2020__0
	//MCX Options Examples : OPTFUT_CRUDEOIL_16JUL2020_PE_2050, OPTFUT_GOLD_27JUL2020_PE_43700	
	//Replace it with appropriate expiry date if this contract is expired

	// Please see symbol naming conventions here : 
	// https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/
*/
function SubscribeSnapshot()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";                   //GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
		var InstIdentifier = "NIFTY-I";
		var Periodicity = "MINUTE";                 //GFDL : Supported values are : Minute, Hour
		var Period = 1;                             //GFDL : Supported values are : 1,2,5,10,15,30 (for Minute Periodicity ONLY)
		var Unsubscribe = "false";               	//GFDL : To stop data subscription for this symbol, send this value as "true"

		request = '{"MessageType":"SubscribeSnapshot","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Periodicity":"' + Periodicity +'","Period":' + Period +',"Unsubscribe":"' + Unsubscribe + '"}';
		callAPI(request);
	}
}
	

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/* 	GFDL : 	1. 	Below 3 functions return the data of SINGLE SYMBOL - whenever requested.
				2. 	So you will need to send these requests EVERY TIME when you need latest data.
				3. 	GetLastQuote : returns single record of realtime data of single symbol. Contains many fields in response
				4. 	GetLastQuoteShort : returns single record of realtime data of single symbol. Contains limited fields in response
				5. 	GetLastQuoteShortWithClose : returns single record of realtime data of single symbol. Contains limited fields in response
				6.	If you want to get data of multiple symbols, you will need to send 1 request each - for each symbol
				
					To know about symbol naming conventions, see SubscribeRealtime / SubscribeSnapshot functions above
				
					Please see symbol naming conventions here : 
					https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/			
	*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function GetLastQuote()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		var InstIdentifier = "NIFTY-I";
		var isShortIdentifier = "false";         	//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
													//this argument must be sent with value "true" 

		request = '{"MessageType":"GetLastQuote","Exchange":"' + ExchangeName + '","isShortIdentifier":"' + isShortIdentifier +'","InstrumentIdentifier":"' + InstIdentifier + '"}';
		callAPI(request);
	}
}

function GetLastQuoteShort()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		var InstIdentifier = "NIFTY-I";
		var isShortIdentifier = "false";         	//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
													//this argument must be sent with value "true" 

		request = '{"MessageType":"GetLastQuoteShort","Exchange":"' + ExchangeName + '","isShortIdentifier":"' + isShortIdentifier +'","InstrumentIdentifier":"' + InstIdentifier + '"}';
		callAPI(request);
	}
}

function GetLastQuoteShortWithClose()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		var InstIdentifier = "NIFTY20JULFUT";		//GFDL : If this contract is expired, please use other contract
		var isShortIdentifier = "true";         	//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
													//this argument must be sent with value "true" 

		request = '{"MessageType":"GetLastQuoteShortWithClose","Exchange":"' + ExchangeName + '","isShortIdentifier":"' + isShortIdentifier +'","InstrumentIdentifier":"' + InstIdentifier + '"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/* 	GFDL : 	1. 	Below 3 functions return the data of MULTIPLE SYMBOLS (MAX 25IN SINGLE CALL) - whenever requested.
				2. 	So you will need to send these requests EVERY TIME when you need latest data.
				3. 	GetLastQuoteArray : returns array of realtime data of multiple symbols. Contains many fields in response
				4. 	GetLastQuoteArrayShort : returns array of realtime data of multiple symbols. Contains limited fields in response
				5. 	GetLastQuoteArrayShortWithClose : returns array of realtime data of multiple symbols. Contains limited fields in response
				6.	If you want to get data of multiple symbols (more than 25), you will need to send more requests - 1 each for 25 symbols

					To know about symbol naming conventions, see SubscribeRealtime / SubscribeSnapshot functions above
				
					Please see symbol naming conventions here : 
					https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/			
	*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function GetLastQuoteArray()
{
	if (connection.connected) 
	{
		var ExchangeName = "NSE";
		var InstIdentifier = '[{"Value":"TATAPOWER"}, {"Value":"RELIANCE"}]';
		var isShortIdentifiers = false;         				//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
																//this argument must be sent with value "true" 

		request = '{"MessageType":"GetLastQuoteArray","Exchange":"' + ExchangeName + '","isShortIdentifiers":'+ isShortIdentifiers + '","InstrumentIdentifiers":'+ InstIdentifier +'}';
		// request = JSON.stringify({
        //     "MessageType": "GetLastQuoteArray",
        //     "Exchange": ExchangeName,
        //     "isShortIdentifiers": isShortIdentifiers,
        //     "InstrumentIdentifiers": JSON.parse(InstIdentifier)  // Use JSON.parse to convert to actual array
        // });
		
		callAPI(request);
	}
}

function GetLastQuoteArrayShort()
{
	if (connection.connected) 
	{
		var ExchangeName = "NSE";
		var InstIdentifier = '[{"Value":"TATAPOWER"}, {"Value":"RELIANCE"}]';
		var isShortIdentifiers = false;        				//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
																//this argument must be sent with value "true" 

		request = '{"MessageType":"GetLastQuoteArrayShort","Exchange":"' + ExchangeName + '","isShortIdentifiers":'+ isShortIdentifiers + '","InstrumentIdentifiers":'+ InstIdentifier +'}';
		callAPI(request);
	}
}

function GetLastQuoteArrayShortWithClose()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		var InstIdentifier = '[{"Value":"NIFTY20JULFUT"}, {"Value":"BANKNIFTY20JULFUT"}]';	//GFDL : If this contract is expired, please use other contract
		var isShortIdentifiers = false;         				//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
																//this argument must be sent with value "true" 

		request = '{"MessageType":"GetLastQuoteArrayShortWithClose","Exchange":"' + ExchangeName + '","isShortIdentifiers":'+ isShortIdentifiers + '","InstrumentIdentifiers":'+ InstIdentifier +'}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/* 	GFDL : 	1. 	GetSnapshot : Returns latest single snapshot of MULTIPLE SYMBOLS (MAX 25 in single call) as per 
					"Periodicity" & "Period" mentioned
					For example, if Periodicity is "Minute" and "Period" is 1 then server will return the data of 
					the requested instrument(s) whenever 1 minute completes.
				2. 	You will need to send this request EVERY TIME when you need latest data.
				3.	To see this function in action, you should run it during market hours				
				
					To know about symbol naming conventions, see SubscribeRealtime / SubscribeSnapshot functions above
				
					Please see symbol naming conventions here : 
					https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/			
	*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function GetSnapshot()
{
	if (connection.connected) 
	{
		var ExchangeName = "NSE";						//GFDL : 	Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter

		var InstIdentifier = '[{"Value":"TATAPOWER"},{"Value":"RELIANCE"}]';	
		
		var Periodicity = "MINUTE";						//GFDL : 	Supported Values : Minute, Hour
		var Period = 1;									//GFDL : 	Supported Values : 1,2,3,5,10,15,20,30
		var isShortIdentifiers = "false";				//GFDL : 	When using contractwise symbol like NIFTY20JULFUT, 
														//			this argument must be sent with value "true" 

		request = '{"MessageType":"GetSnapshot","Exchange":"' + ExchangeName + '","Periodicity":"' + Periodicity + '","Period":' + Period + ',"isShortIdentifiers":' + isShortIdentifiers + ',"InstrumentIdentifiers":' + InstIdentifier + '}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/* 	GFDL : 	1. 	GetHistory : Returns historical data of SINGLE SYMBOL as per "Periodicity" & "Period" mentioned
				2.	This is a very powerful function which supports many optional parameters to download full / incremental data

					To know about symbol naming conventions, see SubscribeRealtime / SubscribeSnapshot functions above
				
					Please see symbol naming conventions here : 
					https://globaldatafeeds.in/global-datafeeds-apis/global-datafeeds-apis/documentation-support/symbol-naming-convention/			
	*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function GetHistory()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";						//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
		var InstIdentifier = "NIFTY-I";				
		var Periodicity = "MINUTE";						//GFDL : Supported values are : Tick, Minute, Hour, Day, Week, Month
		var Period = 1;									//GFDL : Supported values : 1,2,3,4,5,10,12,15,20,30
		var Max = 10;									//Specify this argument to control the number of records returned.
														//For example, send Max:10 to request only latest 10 records
		var isShortIdentifier = "false";				//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
														//		 this argument must be sent with value "true" 
		//Below code will set Start Time of request to 10 hours before current time
		//This may not work on weekends, change value suitably											
		var From = new Date().getTime()/1000.0-36000;	//Start time of the History as per Epoch time (1st January 1970)
														//Visit https://www.epochconverter.com/ to get formulae to convert human readable 
														//time to Epoch and vice versa (scroll to end of their home page)

														//If you need entire possible history, send From value as 0

		var to = 0;                              		//End time of the History as per Epoch. 
														//To request data till latest moment, skip this argument or 
														//send time in Future (e.g. current time + 1 hour)
		var AdjustSplits = "false";		
		//Given below are various usecases of GetHistory function calls. Uncomment and use the one as per requirement

		//below request will fetch latest 10 bars of 1 minute of NIFTY-I.		
													
		request = '{"MessageType":"GetHistory","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Periodicity":"' + Periodicity + '","Period":' + Period + ',"Max":' + Max + '}';

		//below request will fetch latest 10 Ticks of NIFTY-I
		//request = '{"MessageType":"GetHistory","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Periodicity":"Tick","Period":' + Period + ',"Max":' + Max + '}';

		//below request will fetch some 1 minute bars using From & To parameters of NIFTY-I
		//In below request, it sets the From time to 10 hours before current time
		//request = '{"MessageType":"GetHistory","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Periodicity":"' + Periodicity + '","From":' + From + ',"Period":' + Period + '}';

		//below request will fetch all available bars of 1 minute of NIFTY-I.
		//request = '{"MessageType":"GetHistory","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Periodicity":"' + Periodicity + '","From":0,"Period":' + Period + '}';

		//below request will fetch all available bars of 1 minute of NIFTY-I with AdjustSplits.
		//request = '{"MessageType":"GetHistory","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Periodicity":"' + Periodicity + '","From":0,"Period":' + Period + ',"AdjustSplits":' + AdjustSplits + '}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/* 	GFDL : 	1. 	GetExchanges : Returns array of Exchanges allowed for your API Key
	*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function GetExchanges() 
{
	if (connection.connected) 
	{
		request = '{"MessageType":"GetExchanges"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetInstrumentsOnSearch();				//GFDL : Returns array of max. 20 instruments by selected exchange and 'search string'
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function GetInstrumentsOnSearch()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";		//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
		var Search = "NIFTY";			//GFDL : This is the search string
		var InstrumentType = "FUTIDX";	//GFDL : Optional argument to filter the search by products like FUTIDX, FUTSTK, OPTIDX, OPTSTK, 	
										//FUTCUR, FUTCOM, etc.
		var Product = "NIFTY";			//GFDL : Optional argument to filter the search by products like NIFTY, RELIANCE, etc.
		var OptionType = "PE";			//GFDL : Optional argument to filter the search by OptionTypes like CE, PE
		var Expiry = "30JUL2020";	    //GFDL : Optional argument to filter the search by Expiry like 30JUL2020
		var StrikePrice = 10000; 	    //GFDL : Optional argument to filter the search by Strike Price like 10000, 75.5, 1250, etc.
		var OnlyActive = "TRUE";        //GFDL : Optional argument (default=True) to control returned data. If false, 
										//		 even expired contracts are returned

		request = '{"MessageType":"GetInstrumentsOnSearch","Exchange":"' + ExchangeName + '","Search":"' + Search + '"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/*
	//GetInstruments();						//GFDL : Returns array of instruments by selected exchange 
	
	//VERY VERY IMPORTANT : Huge data of several MB is returned if GetInstruments is called without any optional arguments (NSE & NFO)
							It is strongly advised that users build a local symbol cache at their end and refresh with our server		
							only "on need basis". This will result in faster response time and smoother experience for endusers
	*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function GetInstruments()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		var InstrumentType = "FUTSTK";	//GFDL : Optional argument to filter the search by products like FUTIDX, FUTSTK, OPTIDX, OPTSTK, 	
										//FUTCUR, FUTCOM, etc.
		var Product = "NIFTY";			//GFDL : Optional argument to filter the search by products like NIFTY, RELIANCE, etc.
		var OptionType = "PE";		    //GFDL : Optional argument to filter the search by OptionTypes like CE, PE
		var Expiry = "30JUL2020";	    //GFDL : Optional argument to filter the search by Expiry like 30JUL2020
		var StrikePrice = 10000;    	//GFDL : Optional argument to filter the search by Strike Price like 10000, 75.5, 1250, etc.
		var OnlyActive = "TRUE";   		//GFDL : Optional argument (default=True) to control returned data. If false, 
										//       even expired contracts are returned

		request = '{"MessageType":"GetInstruments","Exchange":"' + ExchangeName + '","InstrumentType":"'+InstrumentType+'"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetInstrumentTypes();					//GFDL : Returns list of Instrument Types (e.g. FUTIDX, FUTSTK, etc.)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function GetInstrumentTypes()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		request = '{"MessageType":"GetInstrumentTypes","Exchange":"' + ExchangeName + '"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetProducts();						//GFDL : Returns list of Products (e.g. NIFTY, BANKNIFTY, GAIL, etc.)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function GetProducts()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		request = '{"MessageType":"GetProducts","Exchange":"' + ExchangeName + '"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetExpiryDates();						//GFDL : Returns array of Expiry Dates (e.g. 25JUN2020, 30JUL2020, etc.)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function GetExpiryDates()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		request = '{"MessageType":"GetExpiryDates","Exchange":"' + ExchangeName + '"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetOptionTypes();			//GFDL : Returns list of Option Types (e.g. CE, PE, etc.)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function GetOptionTypes()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		request = '{"MessageType":"GetOptionTypes","Exchange":"' + ExchangeName + '"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetStrikePrices();		//GFDL : Returns list of Strike Prices (e.g. 10000, 11000, 75.5, etc.)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function GetStrikePrices()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		request = '{"MessageType":"GetStrikePrices","Exchange":"' + ExchangeName + '"}';
		callAPI(request);
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetServerInfo();			//GFDL : Returns the server endpoint where user is connected
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


	function GetServerInfo()
	{
		if (connection.connected) 
		{
			request = '{"MessageType":"GetServerInfo"}';
			callAPI(request);
		}
	}

	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetLimitation();			//GFDL : Returns user account information (functions allowed, Exchanges allowed, symbol limit, etc.)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	function GetLimitation()
	{
		if (connection.connected) 
		{
			request = '{"MessageType":"GetLimitation"}';
			callAPI(request);
		}
	}

	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetMarketMessages();					//GFDL : Returns array of last messages (Market Messages) related to selected exchange
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		
	function GetMarketMessages()
	{
		if (connection.connected) 
		{
			var ExchangeName = "NSE";
			request = '{"MessageType":"GetMarketMessages","Exchange":"' + ExchangeName +'"}';
			callAPI(request);
		}
	}

	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetExchangeMessages();				//GFDL : Returns array of last messages (Exchange Messages) related to selected exchange
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	function GetExchangeMessages()
	{
		if (connection.connected) 
		{
			var ExchangeName = "NSE";
			request = '{"MessageType":"GetExchangeMessages","Exchange:"' + ExchangeName + '"}';
			callAPI(request);
		}
	}
	

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetLastQuoteOptionChain();			//GFDL : Returns OptionChain data in realtime
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function GetLastQuoteOptionChain()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";
		var Product = "RELIANCE";		//GFDL : Mandatory Parameter. Example, RELIANCE, BANKNIFTY, NIFTY
		var OptionType = "PE";		    //GFDL : Optional field, CE or PE. If absent, result is sent for all Option Types
		var Expiry = "30JUL2020";	    //GFDL : Optional field, in DDMMMYYYY format. If absent, result is sent for all active Expiries
		var StrikePrice = 10000;    	//GFDL : Optional field, as a number. If absent, result is sent for all strike prices

		request = '{"MessageType":"GetLastQuoteOptionChain","Exchange":"' + ExchangeName + '","Product":"'+Product+'"}';
		callAPI(request);
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//GetExchangeSnapshot();				//GFDL : Returns entire Exchange Snapshot in realtime
											// This function can return maximum 5 snapshots in single call. You will need to
											// use "From" and "To" parameters to control the dataset required
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function GetExchangeSnapshot()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";					//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
		var Periodicity = "MINUTE";					//GFDL : Mandatory Parameter. Supported Values : Minute, Hour. Default = Minute
		var Period = 1;								//GFDL : Mandatory Parameter. Supported Values : 1,2,5,10,15,30. Default = 1
		var InstrumentType = "FUTIDX";	    		//GFDL : Optional Parameter. FUTIDX, FUTSTK, OPTIDX, OPTSTK, FUTCOM, FUTCUR, etc. 
													//If not mentioned, results are sent for all instrument types

		var From = 1567655100;						//GFDL : Epoch value of time in seconds since 1st January 1970. For example, 1567655100 is 
													//epoch value for Thursday, September 5, 2019 9:15:00 AM in GMT+05:30 timezone. 
													//Optional field to control snapshot start time.
													//Please note that max. 5 snapshots are returned in single call

		var to = 0;                              	//GFDL : Epoch value of time in seconds since 1st January 1970. For example, 1567655100 is 
													//epoch value for Thursday, September 5, 2019 9:15:00 AM in GMT+05:30 timezone. 
													//Optional field to control snapshot end time.

		var nonTraded = "false";				    //GFDL : true/false. When true, results are sent with data of even non traded instruments. 
													//When false, data of only traded instruments during that period is sent 
													//Optional Parameter, default value is "false"
		
		request = '{"MessageType":"GetExchangeSnapshot","Exchange":"' + ExchangeName + '","Periodicity":"' + Periodicity + '","Period":' + Period + '}';

		callAPI(request);
	}
}	
	
function GetLastQuoteOptionGreeks()
{
	if (connection.connected)
	{
		var ExchangeName = "NFO";
		var Token = "52534";
		
		request = '{"MessageType":"GetLastQuoteOptionGreeks","Exchange":"' + ExchangeName + '","Token":'+Token+'}';
		
		callAPI(request);
			
	}
}
	
	
function GetLastQuoteArrayOptionGreeks()
{
	if (connection.connected)
	{
		var ExchangeName = "NFO";
		var Tokens = '[{"Value":39489}, {"Value":39487}]';
		
		request = '{"MessageType":"GetLastQuoteArrayOptionGreeks","Exchange":"' + ExchangeName + '","Tokens":'+ Tokens +'}';
		
		callAPI(request);
	}
	
}	

function GetLastQuoteOptionGreeksChain()
{
	if (connection.connected)
	{
		var ExchangeName = "NFO";
		var Product = "RELIANCE";
		var OptionType = "PE";
		var Expiry = "29JUL2021";
		var StrikePrice = 15000;
	
		request = '{"MessageType":"GetLastQuoteOptionGreeksChain","Exchange":"' + ExchangeName + '","Product":"'+ Product +'"}';
		
		callAPI(request);
	}
	
}
function GetExchangeSnapshotAfterMarket()
{
	if (connection.connected)
	{
		var ExchangeName = "NFO";
		var InstrumentType = "FUTIDX";
		var Periodicity = "Minute";
		var period = 1;
		var Date = 1627639200;

		request = '{"MessageType":"GetExchangeSnapshotAfterMarket","Exchange":"' + ExchangeName + '","InstrumentType":"'+ InstrumentType +'","Periodicity":"'+ Periodicity +'","Period":'+ period +',"Date":'+ Date +'}';
		
		callAPI(request);

	}
}
function SubscribeRealtimeGreeks()
{
	if (connection.connected)
	{
		var ExchangeName = "NFO";
		var Token = "52534";
		var Unsubscribe = "false";               	//GFDL : To stop data subscription for this symbol, send this value as "true"
		request = '{"MessageType":"SubscribeRealtimeGreeks","Exchange":"' + ExchangeName + '","Token":'+Token+',"Unsubscribe":'+Unsubscribe+'}';
		
		callAPI(request);
			
	}
}

function SubscribeSnapshotGreeks()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";                   //GFDL : Supported Values : NFO Mandatory Parameter
		var InstIdentifier = "NIFTY25NOV2525000CE";
		var Periodicity = "MINUTE";                 //GFDL : Supported values are : Minute
		var Period = 1;                             //GFDL : Supported values are : 1
		var Unsubscribe = "false";               	//GFDL : To stop data subscription for this symbol, send this value as "true"

		request = '{"MessageType":"SubscribeSnapshotGreeks","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Periodicity":"' + Periodicity +'","Period":' + Period +',"Unsubscribe":"' + Unsubscribe + '"}';
		callAPI(request);
	}
}

function GetSnapshotGreeks()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";						//GFDL : 	Supported Values : NFO. Mandatory Parameter

		var InstIdentifier = '[{"Value":"NIFTY25NOV2525000CE"},{"Value":"NIFTY25NOV2525000PE"}]';	
		
		var Periodicity = "MINUTE";						//GFDL : 	Supported Values : Minute, Hour
		var Period = 1;									//GFDL : 	Supported Values : 1,2,3,5,10,15,20,30
		var isShortIdentifiers = "true";				//GFDL : 	When using contractwise symbol like NIFTY20JULFUT, 
														//			this argument must be sent with value "true" 

		request = '{"MessageType":"GetSnapshotGreeks","Exchange":"' + ExchangeName + '","Periodicity":"' + Periodicity + '","Period":' + Period + ',"isShortIdentifiers":' + isShortIdentifiers + ',"InstrumentIdentifiers":' + InstIdentifier + '}';
		callAPI(request);
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//SubscribeOptionChain();			//GFDL : Returns array of realtime data of multiple symbols based on "StrikePrice" and "Depth" value.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function SubscribeOptionChain()
{
	if (connection.connected) 
	{
		
		var	ExchangeName= "NFO";					//GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
		var	Product= "BANKNIFTY";					//GFDL : Supported Values : RELIANCE, NIFTY, AXISBANK. Mandatory Parameter
		var	Expiry="07AUG2024";					//GFDL : Format ddMMMyyyy Expiry like 30JUL2020
		var OptionType="PE";					//GFDL : OptionTypes - CE or PE
		var StrikePrice= 49900; 				//GFDL : Strike Price like 10000, 75.5, 1250, etc.
		var	Depth= 5; 							//GFDL : Supported values: 1, 5, 10, 15, 20, to received count value up and down from "StrikePrice"
		var Unsubscribe= "false" ;                 //GFDL : Optional field, set to true to Unsubscribe

		request = '{"MessageType":"SubscribeOptionChain","Exchange":"' + ExchangeName + '","Product":"'+Product+'","Expiry":"'+Expiry+'","StrikePrice":"'+StrikePrice+'","Depth":"'+Depth+'","Unsubscribe":"'+Unsubscribe+'"}';
		callAPI(request);
	}
}

function SubscribeOptionChainGreeks()
{
	if (connection.connected) 
	{
		
		var	ExchangeName= "NFO";					//GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
		var	Product= "BANKNIFTY";					//GFDL : Supported Values : RELIANCE, NIFTY, AXISBANK. Mandatory Parameter
		var	Expiry="07AUG2024";					//GFDL : Format ddMMMyyyy Expiry like 30JUL2020
		var OptionType="PE";					//GFDL : OptionTypes - CE or PE
		var StrikePrice= 49900; 				//GFDL : Strike Price like 10000, 75.5, 1250, etc.
		var	Depth= 5; 							//GFDL : Supported values: 1, 5, 10, 15, 20, to received count value up and down from "StrikePrice"
		var Unsubscribe= "false" ;                 //GFDL : Optional field, set to true to Unsubscribe

		request = '{"MessageType":"SubscribeOptionChainGreeks","Exchange":"' + ExchangeName + '","Product":"'+Product+'","Expiry":"'+Expiry+'","StrikePrice":"'+StrikePrice+'","Depth":"'+Depth+'","Unsubscribe":"'+Unsubscribe+'"}';
		callAPI(request);
	}
}
function SubscribeTopGainersLosers()
{
	if (connection.connected)
	{
		var ExchangeName = "NFO";
		var Count = "52534";
		var Unsubscribe = "false";               	//GFDL : To stop data subscription for this symbol, send this value as "true"
		request = '{"MessageType":"SubscribeTopGainersLosers","Exchange":"' + ExchangeName + '","Count":'+Count+',"Unsubscribe":'+Unsubscribe+'}';
		
		callAPI(request);
			
	}
}
function GetTopGainersLosers()
{
	if (connection.connected)
	{
		var ExchangeName = "NFO";
		var Count = "5";
		
		request = '{"MessageType":"GetTopGainersLosers","Exchange":"' + ExchangeName + '","Count":'+Count+'}';
		
		callAPI(request);
			
	}
}
function GetVolumeShockers()
{
	if (connection.connected)
	{
		var ExchangeName = "NSE";
		var Count = "5";
		var Series = "EQ";
		
		request = '{"MessageType":"GetVolumeShockers","Exchange":"' + ExchangeName + '","Count":'+Count+',"Series":"'+Series+'"}';
		
		callAPI(request);
			
	}
}

function GetHistoryGreeks()
{
	if (connection.connected) 
	{
		var ExchangeName = "NFO";						//GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
		var InstIdentifier = "NIFTY25NOV2525000CE";
		var Periodicity = "MINUTE";						//GFDL : Supported values are : Tick, Minute
		var Period = 1;									//GFDL : Supported values : 1				
		var Max = 10;									//Specify this argument to control the number of records returned.
														//For example, send Max:10 to request only latest 10 records
		var isShortIdentifier = "true";				//GFDL : When using contractwise symbol like NIFTY20JULFUT, 
														//		 this argument must be sent with value "true" 
		//Below code will set Start Time of request to 10 hours before current time
		//This may not work on weekends, change value suitably											
		var From = new Date().getTime()/1000.0-36000;	//Start time of the History as per Epoch time (1st January 1970)
														//Visit https://www.epochconverter.com/ to get formulae to convert human readable 
														//time to Epoch and vice versa (scroll to end of their home page)

														//If you need entire possible history, send From value as 0

		var to = 0;                              		//End time of the History as per Epoch. 
														//To request data till latest moment, skip this argument or 
														//send time in Future (e.g. current time + 1 hour)
			
		//Given below are various usecases of GetHistory function calls. Uncomment and use the one as per requirement

		//below request will fetch latest 10 bars of 1 minute of NIFTY-I.		
													
		request = '{"MessageType":"GetHistoryGreeks","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Periodicity":"' + Periodicity + '","Period":' + Period + ',"isShortIdentifier":"' + isShortIdentifier + '","Max":' + Max + '}';

		callAPI(request);
	}
}

		
});

client.connect(endpoint);